/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.nio.ByteBuffer;
import java.util.Locale;
import jnr.constants.platform.Errno;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;

public class Option
extends RubyObject {
    private ProtocolFamily family;
    private SocketLevel level;
    private SocketOption option;
    private ByteList data;

    public static void createOption(ThreadContext context, RubyClass Object2, RubyClass Socket2) {
        ((RubyModule)Socket2.defineClassUnder(context, "Option", Object2, Option::new)).defineMethods(context, Option.class);
    }

    public Option(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public Option(Ruby runtime2, ProtocolFamily family2, SocketLevel level2, SocketOption option, ByteList data2) {
        this(runtime2, (RubyClass)runtime2.getClassFromPath("Socket::Option"), family2, level2, option, data2);
    }

    public Option(Ruby runtime2, RubyClass klass, ProtocolFamily family2, SocketLevel level2, SocketOption option, ByteList data2) {
        super(runtime2, klass);
        this.family = family2;
        this.level = level2;
        this.option = option;
        this.data = data2;
    }

    @JRubyMethod(required=4, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.family = SocketUtils.protocolFamilyFromArg(context, args2[0]);
        this.level = SocketUtils.levelFromArg(context, args2[1]);
        this.option = SocketUtils.optionFromArg(context, args2[2]);
        this.data = args2[3].convertToString().getByteList();
        return this;
    }

    @JRubyMethod
    public IRubyObject family(ThreadContext context) {
        return Convert.asFixnum(context, this.family.longValue());
    }

    @JRubyMethod
    public IRubyObject level(ThreadContext context) {
        return Convert.asFixnum(context, this.level.longValue());
    }

    @JRubyMethod
    public IRubyObject optname(ThreadContext context) {
        return Convert.asFixnum(context, this.option.longValue());
    }

    @JRubyMethod
    public IRubyObject data(ThreadContext context) {
        return Create.newString(context, this.data).freeze(context);
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        StringBuilder buf = new StringBuilder(32);
        buf.append("#<");
        buf.append(this.metaClass.getRealClass().getName(context)).append(": ").append(this.noPrefix(this.family));
        if (this.level == SocketLevel.SOL_SOCKET) {
            buf.append(" SOCKET ").append(this.noPrefix(this.option));
        } else if (this.family == ProtocolFamily.PF_UNIX) {
            buf.append(" level:").append(this.level.longValue()).append(' ').append(this.noPrefix(this.option));
        } else {
            buf.append(" level:").append(this.level.description()).append(' ').append(this.noPrefix(this.option));
        }
        buf.append(' ').append(this.optionValue()).append('>');
        return Create.newString(context, buf.toString());
    }

    private String noPrefix(ProtocolFamily family2) {
        return family2.description().substring("PF_".length());
    }

    private String noPrefix(SocketOption option) {
        return option.description().substring("SO_".length());
    }

    private String optionValue() {
        return switch (this.option) {
            case SocketOption.SO_DEBUG, SocketOption.SO_ACCEPTCONN, SocketOption.SO_BROADCAST, SocketOption.SO_REUSEADDR, SocketOption.SO_KEEPALIVE, SocketOption.SO_OOBINLINE, SocketOption.SO_SNDBUF, SocketOption.SO_RCVBUF, SocketOption.SO_DONTROUTE, SocketOption.SO_RCVLOWAT, SocketOption.SO_SNDLOWAT -> String.valueOf(Option.unpackInt(this.data));
            case SocketOption.SO_LINGER -> {
                int[] linger = Option.unpackLinger(this.data);
                yield (linger[0] == 0 ? "off " : "on ") + linger[1] + "sec";
            }
            case SocketOption.SO_RCVTIMEO, SocketOption.SO_SNDTIMEO -> Sprintf.getNumberFormat(Locale.getDefault()).format((double)Option.unpackInt(this.data) / 1000.0);
            case SocketOption.SO_ERROR -> Errno.valueOf((long)Option.unpackInt(this.data)).description();
            case SocketOption.SO_TYPE -> Sock.valueOf((long)Option.unpackInt(this.data)).description();
            default -> "";
        };
    }

    public static ByteList packInt(int i2) {
        ByteList result2 = new ByteList(4);
        Pack.packInt_i(result2, i2);
        return result2;
    }

    public static ByteList packLinger(int vonoff, int vsecs) {
        ByteList result2 = new ByteList(8);
        Pack.packInt_i(result2, vonoff);
        Pack.packInt_i(result2, vsecs);
        return result2;
    }

    public static int unpackInt(ByteList data2) {
        return Pack.unpackInt_i(ByteBuffer.wrap(data2.unsafeBytes(), data2.begin(), data2.realSize()));
    }

    public static int[] unpackLinger(ByteList data2) {
        ByteBuffer buf = ByteBuffer.wrap(data2.unsafeBytes(), data2.begin(), data2.realSize());
        int vonoff = Pack.unpackInt_i(buf);
        int vsecs = Pack.unpackInt_i(buf);
        return new int[]{vonoff, vsecs};
    }

    @JRubyMethod(name={"int"}, required=4, meta=true)
    public static IRubyObject rb_int(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        ProtocolFamily family2 = SocketUtils.protocolFamilyFromArg(context, args2[0]);
        SocketLevel level2 = SocketUtils.levelFromArg(context, args2[1]);
        SocketOption option = SocketUtils.optionFromArg(context, args2[2]);
        ByteList data2 = Option.packInt(Convert.toInt(context, args2[3]));
        return new Option(context.getRuntime(), family2, level2, option, data2);
    }

    @JRubyMethod(name={"int"})
    public IRubyObject asInt(ThreadContext context) {
        Option.validateDataSize(context, this.data, 4);
        return Convert.asFixnum(context, Option.unpackInt(this.data));
    }

    @JRubyMethod(required=4, meta=true)
    public static IRubyObject bool(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        ProtocolFamily family2 = SocketUtils.protocolFamilyFromArg(context, args2[0]);
        SocketLevel level2 = SocketUtils.levelFromArg(context, args2[1]);
        SocketOption option = SocketUtils.optionFromArg(context, args2[2]);
        ByteList data2 = Option.packInt(args2[3].isTrue() ? 1 : 0);
        return new Option(context.getRuntime(), family2, level2, option, data2);
    }

    @JRubyMethod
    public IRubyObject bool(ThreadContext context) {
        Option.validateDataSize(context, this.data, 4);
        return context.runtime.newBoolean(Option.unpackInt(this.data) != 0);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject linger(ThreadContext context, IRubyObject self2, IRubyObject vonoffArg, IRubyObject vsecs) {
        IRubyObject vonoff = Convert.checkToInteger(context, vonoffArg);
        int coercedVonoff = !vonoff.isNil() ? ((RubyInteger)vonoff).asInt(context) : (vonoffArg.isTrue() ? 1 : 0);
        ByteList data2 = Option.packLinger(coercedVonoff, Convert.toInt(context, vsecs));
        return new Option(context.runtime, ProtocolFamily.PF_UNSPEC, SocketLevel.SOL_SOCKET, SocketOption.SO_LINGER, data2);
    }

    @JRubyMethod
    public IRubyObject linger(ThreadContext context) {
        Option.validateDataSize(context, this.data, 8);
        int[] linger2 = Option.unpackLinger(this.data);
        return Create.newArray(context, (IRubyObject)Convert.asBoolean(context, linger2[0] != 0), (IRubyObject)Convert.asFixnum(context, linger2[1]));
    }

    @JRubyMethod
    public IRubyObject unpack(ThreadContext context, IRubyObject arg0) {
        return Pack.unpack(context, this.data, arg0.convertToString().getByteList());
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        return Create.newString(context, this.data);
    }

    private static void validateDataSize(ThreadContext context, ByteList data2, int size2) {
        int realSize = data2.realSize();
        if (realSize != size2) {
            throw Error.typeError(context, "size differ.  expected as sizeof(int)=" + size2 + " but " + realSize);
        }
    }
}

