/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fcntl;

import java.io.IOException;
import jnr.constants.Constant;
import jnr.constants.ConstantSet;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.api.Convert;
import org.jruby.api.Define;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.load.Library;

public class FcntlLibrary
implements Library {
    public static final int FD_CLOEXEC = 1;

    @Override
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        ThreadContext context = runtime2.getCurrentContext();
        Object Fcntl2 = Define.defineModule(context, "Fcntl").defineConstant(context, "FD_CLOEXEC", Convert.asFixnum(context, 1));
        FcntlLibrary.loadConstantSet(context, Fcntl2, "Fcntl");
        FcntlLibrary.loadConstantSet(context, Fcntl2, "OpenFlags");
    }

    private static void loadConstantSet(ThreadContext context, RubyModule module, String constantSetName) {
        for (Constant c : ConstantSet.getConstantSet((String)constantSetName)) {
            if (!c.defined() || !Character.isUpperCase(c.name().charAt(0))) continue;
            module.defineConstant(context, c.name(), Convert.asFixnum(context, c.intValue()));
        }
    }
}

