/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyClassPathVariable
extends RubyObject {
    public static void createClassPathVariable(ThreadContext context, RubyModule Enumerable, RubyClass Object2) {
        RubyClassPathVariable self2 = new RubyClassPathVariable(context, Object2);
        Enumerable.extend_object(context, self2);
        context.runtime.defineReadonlyVariable("$CLASSPATH", self2, GlobalVariable.Scope.GLOBAL);
        self2.getMetaClass().defineMethods(context, RubyClassPathVariable.class);
    }

    private RubyClassPathVariable(ThreadContext context, RubyClass Object2) {
        super(context.runtime, Object2);
    }

    @Deprecated(since="1.7.0")
    public IRubyObject append(IRubyObject obj) {
        return this.append(obj.getRuntime().getCurrentContext(), obj);
    }

    @JRubyMethod(name={"append", "<<"})
    public IRubyObject append(ThreadContext context, IRubyObject obj) {
        IRubyObject[] paths = obj.respondsTo("to_a") ? ((RubyArray)obj.callMethod(context, "to_a")).toJavaArrayMaybeUnsafe() : new IRubyObject[]{obj};
        for (IRubyObject path2 : paths) {
            try {
                URL url = this.getURL(path2.convertToString().toString());
                if (url.getProtocol().equals("file")) {
                    path2 = RubyFile.expand_path(context, null, path2);
                    url = this.getURL(path2.convertToString().toString());
                }
                context.runtime.getJRubyClassLoader().addURL(url);
            }
            catch (MalformedURLException mue) {
                throw Error.argumentError(context, mue.getLocalizedMessage());
            }
        }
        return this;
    }

    private URL getURL(String target2) throws MalformedURLException {
        try {
            return new URL(target2);
        }
        catch (MalformedURLException e) {
            File f = new File(target2);
            Object path2 = target2;
            if (f.exists() && f.isDirectory() && !((String)path2).endsWith("/")) {
                path2 = (String)path2 + "/";
            }
            return new URL("file", null, (String)path2);
        }
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size(ThreadContext context) {
        return Convert.asFixnum(context, context.runtime.getJRubyClassLoader().getURLs().length);
    }

    public IRubyObject size() {
        return this.size(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject each(Block block) {
        URL[] urls;
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (URL url : urls = context.runtime.getJRubyClassLoader().getURLs()) {
            block.yield(context, Create.newString(context, url.toString()));
        }
        return context.nil;
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        return this.callMethod(context, "to_a").callMethod(context, "to_s");
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return this.callMethod(context, "to_a").callMethod(context, "inspect");
    }
}

