/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.time;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadableInstant;
import org.jruby.RubyBoolean;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class TimeArgs {
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final IRubyObject secondObj;
    private final IRubyObject usecObj;
    private final boolean dst;

    public TimeArgs(ThreadContext context, IRubyObject year2, IRubyObject month2, IRubyObject day, IRubyObject hour2, IRubyObject minute2, IRubyObject second2, IRubyObject usec2, boolean dst) {
        this.year = TimeArgs.parseYear(context, year2);
        this.month = TimeArgs.parseMonth(context, month2);
        this.day = TimeArgs.parseIntOrDefault(context, day, 1);
        this.hour = TimeArgs.parseIntOrDefault(context, hour2, 0);
        this.minute = TimeArgs.parseIntOrDefault(context, minute2, 0);
        this.secondObj = TimeArgs.parseIntArg(context, second2);
        this.second = TimeArgs.parseIntOrDefault(context, this.secondObj, 0);
        this.validateDayHourMinuteSecond(context);
        this.usecObj = usec2;
        this.dst = dst;
    }

    public TimeArgs(ThreadContext context, IRubyObject[] args2) {
        IRubyObject year2;
        IRubyObject nil;
        IRubyObject usec2;
        IRubyObject second2 = usec2 = (nil = context.nil);
        IRubyObject minute2 = usec2;
        IRubyObject hour2 = usec2;
        IRubyObject day = usec2;
        IRubyObject month2 = usec2;
        boolean dst = false;
        switch (args2.length) {
            default: {
                throw new RuntimeException("BUG: should not get here");
            }
            case 10: {
                if (args2[8] instanceof RubyBoolean) {
                    dst = args2[8].isTrue();
                }
                year2 = args2[5];
                month2 = args2[4];
                day = args2[3];
                hour2 = args2[2];
                minute2 = args2[1];
                second2 = args2[0];
                usec2 = nil;
                break;
            }
            case 8: {
                args2[6] = nil;
            }
            case 7: 
            case 9: {
                usec2 = args2[6];
            }
            case 6: {
                second2 = args2[5];
            }
            case 5: {
                minute2 = args2[4];
            }
            case 4: {
                hour2 = args2[3];
            }
            case 3: {
                day = args2[2];
            }
            case 2: {
                month2 = args2[1];
            }
            case 1: {
                year2 = args2[0];
            }
        }
        this.year = TimeArgs.parseYear(context, year2);
        this.month = TimeArgs.parseMonth(context, month2);
        this.day = TimeArgs.parseIntOrDefault(context, day, 1);
        this.hour = TimeArgs.parseIntOrDefault(context, hour2, 0);
        this.minute = TimeArgs.parseIntOrDefault(context, minute2, 0);
        this.secondObj = TimeArgs.parseIntArg(context, second2);
        this.second = TimeArgs.parseIntOrDefault(context, this.secondObj, 0);
        this.validateDayHourMinuteSecond(context);
        this.usecObj = usec2;
        this.dst = dst;
    }

    public void initializeTime(ThreadContext context, RubyTime time, DateTimeZone dtz) {
        DateTime dt = new DateTime(this.year, this.month, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        long instant = dt.getMillis();
        Chronology chrono = dt.getChronology();
        instant = chrono.days().add(instant, this.day - 1);
        instant = chrono.hours().add(instant, this.hour);
        instant = chrono.minutes().add(instant, this.minute);
        long millis = 0L;
        long nanos = 0L;
        int secondsInRational = -1;
        if (this.usecObj.isNil()) {
            if (!this.secondObj.isNil()) {
                IRubyObject iRubyObject = this.secondObj;
                if (iRubyObject instanceof RubyRational) {
                    long denominator2;
                    RubyRational subSecond = (RubyRational)iRubyObject;
                    if (subSecond.isNegativeNumber(context)) {
                        throw Error.argumentError(context, "argument out of range");
                    }
                    long numerator2 = subSecond.getNumerator().asLong(context);
                    if (numerator2 >= (denominator2 = subSecond.getDenominator().asLong(context))) {
                        secondsInRational = (int)((double)numerator2 / (double)denominator2);
                        subSecond = RubyRational.newRational(context.runtime, numerator2 %= denominator2, denominator2);
                    }
                    double subSeconds = subSecond.asDouble(context) * 1.0E9;
                    millis = (long)subSeconds / 1000000L;
                    nanos = (long)subSeconds % 1000000L;
                } else {
                    double secs = Convert.toDouble(context, this.secondObj);
                    if (secs < 0.0 || secs >= 1.0E9) {
                        throw Error.argumentError(context, "argument out of range");
                    }
                    millis = (int)(secs * 1000.0) % 1000;
                    nanos = (long)(secs * 1.0E9) % 1000000L;
                }
            }
        } else {
            IRubyObject subSecond = this.usecObj;
            if (subSecond instanceof RubyRational) {
                RubyRational subSecond2 = (RubyRational)subSecond;
                if (subSecond2.isNegativeNumber(context)) {
                    throw Error.argumentError(context, "argument out of range");
                }
                double subSeconds = subSecond2.asDouble(context) * 1000.0;
                millis = (long)subSeconds / 1000000L;
                nanos = (long)subSeconds % 1000000L;
            } else {
                IRubyObject subSeconds = this.usecObj;
                if (subSeconds instanceof RubyFloat) {
                    RubyFloat flo = (RubyFloat)subSeconds;
                    if (flo.isNegativeNumber(context)) {
                        throw Error.argumentError(context, "argument out of range");
                    }
                    double micros = flo.asDouble(context);
                    millis = (long)(micros / 1000.0);
                    nanos = (long)Math.rint(micros * 1000.0 % 1000000.0);
                } else {
                    int n = subSeconds = TimeArgs.parseIntArg(context, this.usecObj).isNil() ? 0 : Convert.toInt(context, this.usecObj);
                    if (subSeconds < 0 || subSeconds >= 1000000) {
                        throw Error.argumentError(context, "argument out of range");
                    }
                    double micros = subSeconds;
                    millis = (long)(micros / 1000.0);
                    nanos = (long)Math.rint(micros * 1000.0 % 1000000.0);
                }
            }
        }
        instant = this.second == -1 ? chrono.seconds().add(instant, secondsInRational != -1 ? secondsInRational : 0) : chrono.seconds().add(instant, this.second);
        instant = chrono.millis().add(instant, millis);
        try {
            dt = dt.withMillis(instant);
            dt = dt.withZoneRetainFields(dtz);
            dt = TimeArgs.adjustZoneOffset(dtz, dt, this.dst);
        }
        catch (IllegalFieldValueException e) {
            throw Error.argumentError(context, "time out of range");
        }
        time.setDateTime(dt);
        time.setNSec(nanos);
    }

    private static int parseYear(ThreadContext context, IRubyObject _year) {
        if (_year instanceof RubyString) {
            RubyString yr = (RubyString)_year;
            if (!yr.getEncoding().isAsciiCompatible()) {
                throw Error.argumentError(context, "time string should have ASCII compatible encoding");
            }
            _year = RubyNumeric.str2inum(context.runtime, yr, 10, false, true);
        }
        return Convert.toInt(context, _year);
    }

    private static int parseMonth(ThreadContext context, IRubyObject _month) {
        int month2;
        if (_month.isNil()) {
            return 1;
        }
        IRubyObject tmp = _month.checkStringType();
        if (!tmp.isNil()) {
            String monthStr = tmp.toString().toLowerCase();
            if (monthStr.length() == 3) {
                switch (monthStr) {
                    case "jan": {
                        return 1;
                    }
                    case "feb": {
                        return 2;
                    }
                    case "mar": {
                        return 3;
                    }
                    case "apr": {
                        return 4;
                    }
                    case "may": {
                        return 5;
                    }
                    case "jun": {
                        return 6;
                    }
                    case "jul": {
                        return 7;
                    }
                    case "aug": {
                        return 8;
                    }
                    case "sep": {
                        return 9;
                    }
                    case "oct": {
                        return 10;
                    }
                    case "nov": {
                        return 11;
                    }
                    case "dec": {
                        return 12;
                    }
                }
            }
            try {
                month2 = Integer.parseInt(monthStr);
            }
            catch (NumberFormatException ex) {
                throw Error.argumentError(context, "argument out of range.");
            }
        } else {
            month2 = Convert.toInt(context, _month);
        }
        if (month2 < 1 || month2 > 12) {
            throw Error.argumentError(context, "argument out of range: for month: " + month2);
        }
        return month2;
    }

    private static IRubyObject parseIntArg(ThreadContext context, IRubyObject arg2) {
        if (arg2 == context.nil) {
            return arg2;
        }
        if (arg2 instanceof RubyNumeric) {
            return arg2;
        }
        JavaSites.TimeSites sites = TimeArgs.sites(context);
        if (sites.respond_to_to_int.respondsTo(context, arg2, arg2)) {
            return sites.to_int.call(context, arg2, arg2);
        }
        return sites.to_i.call(context, arg2, arg2);
    }

    private void validateDayHourMinuteSecond(ThreadContext context) {
        if (this.day < 1 || this.day > 31) {
            throw Error.argumentError(context, "argument out of range for day");
        }
        if (this.hour < 0 || this.hour > 24) {
            throw Error.argumentError(context, "argument out of range for hour");
        }
        if (this.minute < 0 || this.minute > 59 || this.hour == 24 && this.minute > 0) {
            throw Error.argumentError(context, "argument out of range for minute");
        }
        if (this.second != -1 && (this.second < 0 || this.second > 60) || this.hour == 24 && this.second > 0) {
            throw Error.argumentError(context, "argument out of range");
        }
    }

    private static int parseIntOrDefault(ThreadContext context, IRubyObject obj, int def) {
        return (obj = TimeArgs.parseIntArg(context, obj)).isNil() ? def : Convert.toInt(context, obj);
    }

    private static DateTime adjustZoneOffset(DateTimeZone dtz, DateTime dt, boolean dst) {
        DateTime beforeDstBoundary = dt.withEarlierOffsetAtOverlap();
        DateTime afterDstBoundary = dt.withLaterOffsetAtOverlap();
        int offsetBeforeBoundary = dtz.getOffset((ReadableInstant)beforeDstBoundary);
        int offsetAfterBoundary = dtz.getOffset((ReadableInstant)afterDstBoundary);
        dt = dst ? (offsetBeforeBoundary > offsetAfterBoundary ? beforeDstBoundary : afterDstBoundary) : (offsetBeforeBoundary > offsetAfterBoundary ? afterDstBoundary : beforeDstBoundary);
        return dt;
    }

    private static JavaSites.TimeSites sites(ThreadContext context) {
        return context.sites.Time;
    }
}

