/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import com.headius.backport9.stack.StackWalker;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.Exception;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class TraceType {
    private static final Logger LOG = LoggerFactory.getLogger(TraceType.class);
    private static final StackWalker WALKER = ThreadContext.WALKER;
    private final Gather gather;
    private final Format format;
    private static final String UNDERLINE = "\u001b[1;4m";
    private static final String BOLD = "\u001b[1m";
    private static final String RESET = "\u001b[m";
    private static final String FIRST_COLOR = "\u001b[0;31m";
    private static final String KERNEL_COLOR = "\u001b[0;36m";
    private static final String EVAL_COLOR = "\u001b[0;33m";
    private static final String CLEAR_COLOR = "\u001b[0m";

    public TraceType(Gather gather, Format format) {
        this.gather = gather;
        this.format = format;
    }

    public Gather getGather() {
        return this.gather;
    }

    public Format getFormat() {
        return this.format;
    }

    public BacktraceData getBacktrace(ThreadContext context) {
        return this.gather.getBacktraceData(context);
    }

    public BacktraceData getIntegratedBacktrace(ThreadContext context, StackTraceElement[] javaTrace) {
        return this.gather.getIntegratedBacktraceData(context, javaTrace);
    }

    public String printBacktrace(RubyException exception2, boolean console) {
        return this.format.printBacktrace(exception2, console);
    }

    public static void logBacktrace(Ruby runtime2, RubyStackTraceElement[] trace2) {
        if (trace2 == null) {
            trace2 = RubyStackTraceElement.EMPTY_ARRAY;
        }
        StringBuilder buffer = new StringBuilder(64 + trace2.length * 48);
        buffer.append("Backtrace generated:\n");
        TraceType.renderBacktraceJRuby(runtime2, trace2, buffer, false);
        LOG.info(buffer.toString(), new Object[0]);
    }

    public static void logException(RubyException exception2) {
        LOG.info("Exception raised: {} : {}", exception2.getMetaClass(), exception2);
    }

    @Deprecated(since="9.4-")
    public static void dumpException(RubyException exception2) {
        TraceType.logException(exception2);
    }

    public static void dumpBacktrace(RubyException exception2) {
        Ruby runtime2 = exception2.getRuntime();
        System.err.println("Backtrace generated:" + System.lineSeparator() + TraceType.printBacktraceJRuby(exception2, runtime2.getPosix().isatty(FileDescriptor.err)));
    }

    public static void logCaller(RubyArray trace2) {
        StringBuilder buffer = new StringBuilder(64 + trace2.size() * 48);
        buffer.append("Caller backtrace generated:\n");
        for (int i2 = 0; i2 < trace2.size(); ++i2) {
            buffer.append("  ").append(trace2.eltInternal(i2)).append(System.lineSeparator());
        }
        LOG.info(buffer.toString(), new Object[0]);
    }

    @Deprecated(since="9.4-")
    public static void dumpCaller(RubyArray trace2) {
        TraceType.logCaller(trace2);
    }

    public static void logCaller(RubyStackTraceElement[] trace2) {
        if (trace2 == null) {
            trace2 = RubyStackTraceElement.EMPTY_ARRAY;
        }
        LOG.info(TraceType.formatWithMRIBacktrace("Caller backtrace generated:" + System.lineSeparator(), trace2).toString(), new Object[0]);
    }

    private static StringBuilder formatWithMRIBacktrace(String message2, RubyStackTraceElement[] trace2) {
        StringBuilder buffer = new StringBuilder(64 + trace2.length * 48);
        buffer.append(message2);
        TraceType.renderBacktraceMRI(trace2, "  ", buffer, false);
        return buffer;
    }

    @Deprecated(since="9.4-")
    public static void dumpCaller(RubyStackTraceElement[] trace2) {
        TraceType.logCaller(trace2);
    }

    public static void logWarning(RubyStackTraceElement[] trace2) {
        if (trace2 == null) {
            trace2 = RubyStackTraceElement.EMPTY_ARRAY;
        }
        LOG.info(TraceType.formatWithMRIBacktrace("Warning backtrace generated:" + System.lineSeparator(), trace2).toString(), new Object[0]);
    }

    @Deprecated(since="9.4-")
    public static void dumpWarning(RubyStackTraceElement[] trace2) {
        TraceType.logWarning(trace2);
    }

    public static TraceType traceTypeFor(String style) {
        if (style.equalsIgnoreCase("raw")) {
            return new TraceType(Gather.RAW, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("ruby_framed")) {
            return new TraceType(Gather.NORMAL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("normal")) {
            return new TraceType(Gather.NORMAL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("full")) {
            return new TraceType(Gather.FULL, Format.JRUBY);
        }
        if (style.equalsIgnoreCase("mri")) {
            return new TraceType(Gather.NORMAL, Format.MRI);
        }
        return new TraceType(Gather.NORMAL, Format.JRUBY);
    }

    public static IRubyObject printDetailedMessage(ThreadContext context, IRubyObject exception2, IRubyObject opts) {
        IRubyObject optArg = ArgsUtil.getOptionsArg(context, opts);
        IRubyObject highlightArg = TraceType.checkHighlightKeyword(context, optArg, false);
        RubyString errorStream = Create.newEmptyString(context);
        TraceType.printErrMessageToStream(context, exception2, errorStream, highlightArg.isTrue());
        return errorStream;
    }

    public static RubyString printFullMessage(ThreadContext context, IRubyObject exception2, IRubyObject opts) {
        IRubyObject optArg = ArgsUtil.getOptionsArg(context, opts);
        IRubyObject highlightArg = TraceType.checkHighlightKeyword(context, optArg, true);
        boolean reverse2 = TraceType.checkOrderKeyword(context, optArg);
        if (optArg.isNil()) {
            optArg = Create.newHash(context);
        }
        ((RubyHash)optArg).fastASet(Convert.asSymbol(context, "highlight"), highlightArg);
        return TraceType.printBacktraceMRI(exception2, optArg, highlightArg.isTrue(), reverse2);
    }

    private static boolean checkOrderKeyword(ThreadContext context, IRubyObject optArg) {
        boolean reverse2;
        if (optArg.isNil()) {
            reverse2 = false;
        } else {
            RubyHash optHash = (RubyHash)optArg;
            IRubyObject highlightOrder = optHash.fastARef(Convert.asSymbol(context, "order"));
            reverse2 = TraceType.determineDirection(context, highlightOrder);
        }
        return reverse2;
    }

    private static IRubyObject checkHighlightKeyword(ThreadContext context, IRubyObject optArg, boolean autoTTYDetect) {
        IRubyObject highlightArg = context.nil;
        RubySymbol highlightSym = Convert.asSymbol(context, "highlight");
        if (!optArg.isNil()) {
            RubyHash optHash = (RubyHash)optArg;
            highlightArg = optHash.fastARef(highlightSym);
            if (highlightArg == null) {
                highlightArg = context.nil;
            }
            if (!highlightArg.isNil() && highlightArg != context.tru && highlightArg != context.fals) {
                throw Error.argumentError(context, "expected true or false as highlight: " + String.valueOf(highlightArg));
            }
        }
        if (highlightArg.isNil()) {
            highlightArg = Convert.asBoolean(context, autoTTYDetect && RubyException.to_tty_p(context, Access.exceptionClass(context)).isTrue());
        }
        return highlightArg;
    }

    private static boolean determineDirection(ThreadContext context, IRubyObject vOrder) {
        if (vOrder == null || vOrder.isNil()) {
            return false;
        }
        RubySymbol id2 = Check.checkID(context, vOrder);
        if (id2 == Convert.asSymbol(context, "bottom")) {
            return true;
        }
        if (id2 == Convert.asSymbol(context, "top")) {
            return false;
        }
        throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "expected :top or :bottom as order: ", vOrder));
    }

    private static RubyString printBacktraceMRI(IRubyObject exception2, IRubyObject opts, boolean highlight, boolean reverse2) {
        RubyString errorStream = Create.newEmptyString(exception2.getRuntime().getCurrentContext());
        if (reverse2) {
            if (highlight) {
                errorStream.catString(BOLD);
            }
            errorStream.catString("Traceback");
            if (highlight) {
                errorStream.catString(RESET);
            }
            errorStream.catString(" (most recent call last):" + System.lineSeparator());
        }
        HashSet<Object> shownCauses = new HashSet<Object>();
        TraceType.printExceptionToStream(exception2, errorStream, opts, highlight, reverse2, shownCauses);
        return errorStream;
    }

    private static void printExceptionToStream(IRubyObject exception2, RubyString errorStream, IRubyObject opts, boolean highlight, boolean reverse2, Set<Object> shownCauses) {
        Ruby runtime2 = exception2.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject backtrace2 = exception2.callMethod(context, "backtrace");
        if (reverse2) {
            TraceType.printCauseToStream(context, exception2, errorStream, opts, highlight, reverse2, shownCauses);
            TraceType.printBacktraceToStream(context, backtrace2, errorStream, reverse2, 1);
            TraceType.printErrInfoToStream(exception2, backtrace2, errorStream, opts, highlight);
        } else {
            TraceType.printErrInfoToStream(exception2, backtrace2, errorStream, opts, highlight);
            TraceType.printBacktraceToStream(context, backtrace2, errorStream, reverse2, 1);
            TraceType.printCauseToStream(context, exception2, errorStream, opts, highlight, reverse2, shownCauses);
        }
    }

    private static void printCauseToStream(ThreadContext context, IRubyObject exception2, RubyString errorStream, IRubyObject opts, boolean highlight, boolean reverse2, Set<Object> shownCauses) {
        IRubyObject cause2 = exception2.callMethod(context, "cause");
        if (!cause2.isNil() && !shownCauses.contains(cause2)) {
            shownCauses.add(cause2);
            TraceType.printExceptionToStream(cause2, errorStream, opts, highlight, reverse2, shownCauses);
        }
    }

    private static void printErrInfoToStream(IRubyObject exception2, IRubyObject backtrace2, RubyString errorStream, IRubyObject opts, boolean highlight) {
        Ruby runtime2 = exception2.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        boolean printedPosition = false;
        if (backtrace2 == null || backtrace2.isNil() || !(backtrace2 instanceof RubyArray)) {
            if (context.getFile() != null && context.getFile().length() > 0) {
                errorStream.catString(context.getFile() + ":" + (context.getLine() + 1));
                printedPosition = true;
            } else {
                errorStream.catString("" + (context.getLine() + 1));
                printedPosition = true;
            }
            String method2 = context.getFrameName();
            if (method2 == null) {
                method2 = "full_message";
            }
            errorStream.catString(":in '");
            errorStream.catString(method2);
            errorStream.cat(39);
        } else if (((RubyArray)backtrace2).getLength() == 0) {
            TraceType.printErrorPos(context, errorStream);
        } else {
            IRubyObject mesg = ((RubyArray)backtrace2).first(context);
            if (mesg.isNil()) {
                TraceType.printErrorPos(context, errorStream);
            } else {
                errorStream.append(mesg);
                printedPosition = true;
            }
        }
        RubyClass type2 = exception2.getMetaClass();
        String info = exception2.toString();
        if (type2 == runtime2.getRuntimeError() && (info == null || info.length() == 0)) {
            errorStream.catString(": ");
        } else if (printedPosition) {
            errorStream.catString(": ");
        }
        IRubyObject message2 = context.nil;
        if (exception2.respondsTo("detailed_message")) {
            if (opts.isNil()) {
                message2 = exception2.callMethod(context, "detailed_message");
            } else {
                context.callInfo = 6;
                message2 = exception2.callMethod(context, "detailed_message", opts);
            }
        }
        if (message2 instanceof RubyString) {
            RubyString str = (RubyString)message2;
            errorStream.append(str);
        } else if (message2.isNil()) {
            if (highlight) {
                errorStream.catString(UNDERLINE);
            }
            errorStream.append(type2.getRealClass().rubyName(context));
            if (highlight) {
                errorStream.catString(RESET);
            }
        } else {
            errorStream.append(message2.convertToString());
        }
        errorStream.cat(10);
    }

    private static void printErrMessageToStream(ThreadContext context, IRubyObject exception2, RubyString errorStream, boolean highlight) {
        RubyClass type2 = exception2.getMetaClass();
        String info = exception2.toString();
        if (type2 == context.runtime.getRuntimeError() && (info == null || info.length() == 0)) {
            if (highlight) {
                errorStream.catString(UNDERLINE);
            }
            errorStream.catString("unhandled exception");
            if (highlight) {
                errorStream.catString(RESET);
            }
        } else {
            String path2 = type2.getName(context);
            if (info.length() == 0) {
                if (highlight) {
                    errorStream.catString(UNDERLINE);
                }
                errorStream.catString(path2);
                if (highlight) {
                    errorStream.catString(RESET);
                }
            } else {
                if (highlight) {
                    errorStream.catString(BOLD);
                }
                if (path2.startsWith("#")) {
                    path2 = null;
                }
                String tail = null;
                int idx = info.indexOf(10);
                if (idx != -1) {
                    tail = info.substring(idx + 1);
                    info = info.substring(0, idx);
                }
                errorStream.catString(info);
                if (path2 != null) {
                    errorStream.catString(" (");
                    if (highlight) {
                        errorStream.catString(UNDERLINE);
                    }
                    errorStream.catString(path2);
                    if (highlight) {
                        errorStream.catString(RESET);
                        errorStream.catString(BOLD);
                    }
                    errorStream.cat(41);
                    if (highlight) {
                        errorStream.catString(RESET);
                    }
                }
                if (tail != null && tail.length() > 0) {
                    errorStream.catString(System.lineSeparator());
                    if (!highlight) {
                        errorStream.catString(tail);
                    } else {
                        int start2 = 0;
                        int end2 = tail.indexOf(10);
                        while (end2 != -1) {
                            errorStream.catString(BOLD);
                            errorStream.catString(tail.substring(start2, end2));
                            errorStream.catString(RESET);
                            errorStream.catString(System.lineSeparator());
                            start2 = end2 + 1;
                            end2 = tail.indexOf(10, start2);
                        }
                        errorStream.catString(BOLD);
                        errorStream.catString(tail.substring(start2));
                        errorStream.catString(RESET);
                    }
                }
            }
        }
    }

    public static String printBacktraceJRuby(Ruby runtime2, RubyStackTraceElement[] frames, String type2, String message2, boolean color) {
        if (frames == null) {
            frames = RubyStackTraceElement.EMPTY_ARRAY;
        }
        StringBuilder buffer = new StringBuilder(64 + frames.length * 48);
        buffer.append(type2).append(": ").append(message2).append('\n');
        TraceType.renderBacktraceJRuby(runtime2, frames, buffer, color);
        return buffer.toString();
    }

    protected static String printBacktraceJRuby(RubyException exception2, boolean console) {
        Ruby runtime2 = exception2.getRuntime();
        console = console && runtime2.getInstanceConfig().getBacktraceColor();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream errorStream = new PrintStream(baos);
        TraceType.printBacktraceJRubyToStream(exception2, errorStream, console);
        HashSet<Object> shownCauses = new HashSet<Object>();
        Object cause2 = exception2.getCause();
        while (cause2 instanceof RubyException && !shownCauses.contains(cause2)) {
            TraceType.printBacktraceJRubyToStream((RubyException)cause2, errorStream, console);
            shownCauses.add(cause2);
            cause2 = ((RubyException)cause2).getCause();
        }
        return baos.toString();
    }

    private static void printBacktraceJRubyToStream(RubyException exception2, PrintStream errorStream, boolean console) {
        String message2;
        Ruby runtime2 = exception2.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        try {
            message2 = exception2.callMethod(context, "message").toString();
        }
        catch (Exception unused2) {
            message2 = exception2.message(context).toString();
        }
        if (exception2.getMetaClass() == runtime2.getRuntimeError() && message2.length() == 0) {
            message2 = "No current exception";
        }
        String type2 = exception2.getMetaClass().getName(context);
        errorStream.print(TraceType.printBacktraceJRuby(runtime2, exception2.getBacktraceElements(), type2, message2, console));
    }

    private static void renderBacktraceJRuby(Ruby runtime2, RubyStackTraceElement[] frames, StringBuilder buffer, boolean color) {
        int optionBacktraceLimit = Integer.MAX_VALUE;
        int maxBacktraceLines = frames.length;
        int longestMethod = 0;
        for (RubyStackTraceElement frame : frames) {
            longestMethod = Math.max(longestMethod, frame.getMethodName().length());
        }
        if (runtime2 != null) {
            optionBacktraceLimit = runtime2.getInstanceConfig().getBacktraceLimit();
            maxBacktraceLines = optionBacktraceLimit > frames.length || optionBacktraceLimit == -1 ? frames.length : optionBacktraceLimit;
        }
        boolean first2 = true;
        for (int i2 = 0; i2 < maxBacktraceLines; ++i2) {
            RubyStackTraceElement frame = frames[i2];
            if (color) {
                if (first2) {
                    buffer.append(FIRST_COLOR);
                } else if (frame.isBinding() || frame.getFileName().startsWith("(eval")) {
                    buffer.append(EVAL_COLOR);
                } else if (frame.getFileName().indexOf(".java") != -1) {
                    buffer.append(KERNEL_COLOR);
                }
                first2 = false;
            }
            buffer.append("  ");
            String methodName = runtime2 == null ? frame.getMethodName() : runtime2.newSymbol(frame.getMethodName()).idString();
            for (int j = 0; j < longestMethod - methodName.length(); ++j) {
                buffer.append(' ');
            }
            buffer.append(methodName).append(" at ").append(frame.getFileName()).append(':').append(frame.getLineNumber());
            if (color) {
                buffer.append(CLEAR_COLOR);
            }
            buffer.append(System.lineSeparator());
        }
        if (runtime2 != null && frames.length > maxBacktraceLines) {
            String suppressedLines = String.valueOf(frames.length - maxBacktraceLines);
            buffer.append("... " + suppressedLines + " levels..." + System.lineSeparator());
        }
    }

    private static void renderBacktraceMRI(RubyStackTraceElement[] trace2, String linePrefix, StringBuilder buffer, boolean color) {
        for (int i2 = 0; i2 < trace2.length; ++i2) {
            RubyStackTraceElement element = trace2[i2];
            buffer.append(linePrefix).append(element.getFileName()).append(':').append(element.getLineNumber()).append(":in '").append(element.getMethodName()).append("'\n");
        }
    }

    private static void printErrorPos(ThreadContext context, RubyString errorStream) {
        if (context.getFile() != null && context.getFile().length() > 0) {
            if (context.getFrameName() != null) {
                errorStream.catString(context.getFile() + ":" + context.getLine());
                errorStream.catString(":in '" + context.getFrameName() + "'");
            } else if (context.getLine() != 0) {
                errorStream.catString(context.getFile() + ":" + context.getLine());
            } else {
                errorStream.catString(context.getFile());
            }
        }
    }

    public static void printBacktraceToStream(ThreadContext context, IRubyObject backtrace2, RubyString errorStream, int skip2) {
        TraceType.printBacktraceToStream(context, backtrace2, errorStream, false, skip2);
    }

    public static void printBacktraceToStream(ThreadContext context, IRubyObject backtrace2, RubyString errorStream, boolean reverse2, int skip2) {
        if (backtrace2.isNil()) {
            return;
        }
        if (backtrace2 instanceof RubyArray) {
            int i2;
            int maxBacktraceLines;
            RubyArray bt = (RubyArray)backtrace2;
            IRubyObject[] elements = bt.toJavaArrayMaybeUnsafe();
            int optionBacktraceLimit = Access.instanceConfig(context).getBacktraceLimit();
            int limitPlusSkip = optionBacktraceLimit + skip2;
            int len = maxBacktraceLines = optionBacktraceLimit == -1 || limitPlusSkip > elements.length ? elements.length : limitPlusSkip;
            int threshold = 1000000000;
            int width = len <= 1 ? Integer.MIN_VALUE : (int)Math.log10(len > 1000000000 ? (len - 1) / 1000000000 : len - 1) + (len < 1000000000 ? 0 : 9) + 1;
            for (i2 = skip2; i2 < maxBacktraceLines; ++i2) {
                IRubyObject stackTraceLine = elements[reverse2 ? len - i2 : i2];
                errorStream.cat(9);
                if (reverse2) {
                    errorStream.catString(String.format("%" + width + "d: ", len - i2));
                }
                if (stackTraceLine instanceof RubyString) {
                    errorStream.catString("from " + String.valueOf(stackTraceLine));
                    errorStream.catString(System.lineSeparator());
                    continue;
                }
                errorStream.append(stackTraceLine);
            }
            if (elements.length > i2) {
                String suppressedLines = String.valueOf(elements.length - i2);
                errorStream.catString("\t ... " + suppressedLines + " levels..." + System.lineSeparator());
            }
        }
    }

    public static IRubyObject generateMRIBacktrace(Ruby runtime2, RubyStackTraceElement[] trace2) {
        if (trace2 == null) {
            return runtime2.getNil();
        }
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject[] traceArray = new IRubyObject[trace2.length];
        for (int i2 = 0; i2 < trace2.length; ++i2) {
            traceArray[i2] = RubyStackTraceElement.to_s_mri(context, trace2[i2]);
        }
        return RubyArray.newArrayMayCopy(runtime2, traceArray);
    }

    public static String maskInternalFiles(String filename2) {
        if (TraceType.isInternalFile(filename2)) {
            return "<internal:" + filename2 + ">";
        }
        return filename2;
    }

    public static boolean isInternalFile(String filename2) {
        return filename2 != null && filename2.startsWith("uri:classloader:/jruby/kernel/");
    }

    public static boolean hasInternalMarker(String filename2) {
        return filename2.startsWith("<internal:");
    }

    public static boolean isExcludedInternal(String filename2) {
        return TraceType.isInternalFile(filename2) || TraceType.hasInternalMarker(filename2);
    }

    @Deprecated
    public RubyStackTraceElement getBacktraceElement(ThreadContext context, int uplevel) {
        RubyStackTraceElement[] elements = this.getBacktrace(context).getBacktrace(context.runtime);
        if (elements.length <= uplevel + 1) {
            uplevel = -1;
        }
        return elements[uplevel + 1];
    }

    public static enum Gather {
        RAW{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, Stream.empty(), true, true, false, false, false);
            }
        }
        ,
        FULL{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, context.getBacktrace(), true, false, false, false, false);
            }
        }
        ,
        INTEGRATED{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, context.getBacktrace(), false, false, false, true, false);
            }
        }
        ,
        NORMAL{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, context.getBacktrace(), false, false, Access.instanceConfig(context).getBacktraceMask(), false, false);
            }
        }
        ,
        CALLER{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, context.getBacktrace(), false, false, true, false, false);
            }
        }
        ,
        WARN{

            @Override
            public BacktraceData getBacktraceData(ThreadContext context, Stream<StackWalker.StackFrame> stackStream) {
                return new BacktraceData(stackStream, context.getBacktrace(), false, false, true, false, true);
            }
        };


        public BacktraceData getBacktraceData(ThreadContext context) {
            return (BacktraceData)WALKER.walk(Thread.currentThread().getStackTrace(), stream -> {
                BacktraceData data2 = this.getBacktraceData(context, (Stream<StackWalker.StackFrame>)stream);
                context.runtime.incrementBacktraceCount();
                if (RubyInstanceConfig.LOG_BACKTRACES) {
                    TraceType.logBacktrace(context.runtime, data2.getBacktrace(context.runtime));
                }
                return data2;
            });
        }

        public BacktraceData getIntegratedBacktraceData(ThreadContext context, StackTraceElement[] javaTrace) {
            Gather useGather = this == NORMAL ? INTEGRATED : this;
            return (BacktraceData)WALKER.walk(javaTrace, stream -> {
                BacktraceData data2 = useGather.getBacktraceData(context, (Stream<StackWalker.StackFrame>)stream);
                context.runtime.incrementBacktraceCount();
                if (RubyInstanceConfig.LOG_BACKTRACES) {
                    TraceType.logBacktrace(context.runtime, data2.getBacktrace(context.runtime));
                }
                return data2;
            });
        }

        public abstract BacktraceData getBacktraceData(ThreadContext var1, Stream<StackWalker.StackFrame> var2);
    }

    public static enum Format {
        MRI{

            @Override
            public String printBacktrace(RubyException exception2, boolean console) {
                RubyHash opts = RubyHash.newKwargs(exception2.getRuntime(), "highlight", exception2.getRuntime().newBoolean(console));
                return TraceType.printBacktraceMRI(exception2, opts, console, false).toString();
            }

            @Override
            public void renderBacktrace(RubyStackTraceElement[] elts, StringBuilder buffer, boolean color) {
                TraceType.renderBacktraceMRI(elts, "\tfrom ", buffer, color);
            }
        }
        ,
        JRUBY{

            @Override
            public String printBacktrace(RubyException exception2, boolean console) {
                return TraceType.printBacktraceJRuby(exception2, console);
            }

            @Override
            public void renderBacktrace(RubyStackTraceElement[] elts, StringBuilder buffer, boolean color) {
                TraceType.renderBacktraceJRuby(null, elts, buffer, color);
            }
        };


        public abstract String printBacktrace(RubyException var1, boolean var2);

        public abstract void renderBacktrace(RubyStackTraceElement[] var1, StringBuilder var2, boolean var3);
    }
}

