/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jnr.netdb.NetDBEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NetDBIterator
implements Iterator<NetDBEntry> {
    private final BufferedReader reader;
    private NetDBEntry next = null;

    public NetDBIterator(Reader r) {
        this.reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
    }

    NetDBEntry readNextEntry() {
        try {
            String s;
            while ((s = this.reader.readLine()) != null) {
                List<String> aliases;
                String[] fields;
                String[] line = s.split("#", 2);
                if (line.length < 0 || line[0].isEmpty() || (fields = line[0].trim().split("\\s+")).length < 2 || fields[0] == null || fields[1] == null) continue;
                String serviceName = fields[0];
                String data = fields[1];
                if (fields.length > 2) {
                    aliases = new ArrayList(fields.length - 2);
                    for (int i = 2; i < fields.length; ++i) {
                        if (fields[i] == null) continue;
                        aliases.add(fields[i]);
                    }
                } else {
                    aliases = Collections.emptyList();
                }
                return new NetDBEntry(serviceName, data, aliases);
            }
        }
        catch (IOException ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.next != null || (this.next = this.readNextEntry()) != null;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    @Override
    public NetDBEntry next() {
        NetDBEntry s = this.next != null ? this.next : this.readNextEntry();
        this.next = null;
        return s;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

