/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import jnr.netdb.NetDBEntry;
import jnr.netdb.NetDBParser;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileProtocolsDB
implements ProtocolsDB {
    public static final FileProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    FileProtocolsDB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileProtocolsDB load() {
        try {
            NetDBParser parser = FileProtocolsDB.parseProtocolsFile();
            try {
                parser.iterator().next();
            }
            finally {
                parser.close();
            }
            return new FileProtocolsDB();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public Protocol getProtocolByName(final String name) {
        return this.parse(new Filter(){

            public boolean filter(Protocol p) {
                if (p.getName().equals(name)) {
                    return true;
                }
                for (String alias : p.getAliases()) {
                    if (!alias.equals(name)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Protocol getProtocolByNumber(final Integer proto) {
        return this.parse(new Filter(){

            public boolean filter(Protocol p) {
                return p.getProto() == proto.intValue();
            }
        });
    }

    @Override
    public Collection<Protocol> getAllProtocols() {
        final LinkedList allProtocols = new LinkedList();
        this.parse(new Filter(){

            public boolean filter(Protocol s) {
                allProtocols.add(s);
                return false;
            }
        });
        return Collections.unmodifiableList(allProtocols);
    }

    static final NetDBParser parseProtocolsFile() {
        try {
            return new NetDBParser(new FileReader(new File("/etc/protocols")));
        }
        catch (FileNotFoundException ex) {
            return new NetDBParser(new StringReader(""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Protocol parse(Filter filter) {
        NetDBParser parser = FileProtocolsDB.parseProtocolsFile();
        try {
            for (NetDBEntry e : parser) {
                try {
                    Protocol p = new Protocol(e.name, Integer.parseInt(e.data, 10), e.aliases);
                    if (!filter.filter(p)) continue;
                    Protocol protocol = p;
                    return protocol;
                }
                catch (NumberFormatException ex) {}
            }
        }
        finally {
            try {
                parser.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    static /* synthetic */ FileProtocolsDB access$000() {
        return FileProtocolsDB.load();
    }

    private static interface Filter {
        public boolean filter(Protocol var1);
    }

    private static final class SingletonHolder {
        public static final FileProtocolsDB INSTANCE = FileProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

