/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public abstract class MemoryIO {
    private final Foreign foreign = Foreign.getInstance();
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();

    public static MemoryIO getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private MemoryIO() {
    }

    private static final MemoryIO getImpl() {
        try {
            return !Boolean.getBoolean("jffi.unsafe.disabled") && MemoryIO.isUnsafeAvailable() ? MemoryIO.newUnsafeImpl() : MemoryIO.newNativeImpl();
        }
        catch (Throwable t) {
            return MemoryIO.newNativeImpl();
        }
    }

    private static final MemoryIO newNativeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newNativeImpl32() : MemoryIO.newNativeImpl64();
    }

    private static final MemoryIO newNativeImpl32() {
        return new NativeImpl32();
    }

    private static final MemoryIO newNativeImpl64() {
        return new NativeImpl64();
    }

    private static final MemoryIO newUnsafeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newUnsafeImpl32() : MemoryIO.newUnsafeImpl64();
    }

    private static final MemoryIO newUnsafeImpl32() {
        return new UnsafeImpl32();
    }

    private static final MemoryIO newUnsafeImpl64() {
        return new UnsafeImpl64();
    }

    public abstract byte getByte(long var1);

    public abstract short getShort(long var1);

    public abstract int getInt(long var1);

    public abstract long getLong(long var1);

    public abstract float getFloat(long var1);

    public abstract double getDouble(long var1);

    public abstract long getAddress(long var1);

    public abstract void putByte(long var1, byte var3);

    public abstract void putShort(long var1, short var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putLong(long var1, long var3);

    public abstract void putFloat(long var1, float var3);

    public abstract void putDouble(long var1, double var3);

    public abstract void putAddress(long var1, long var3);

    public abstract void copyMemory(long var1, long var3, long var5);

    public abstract void setMemory(long var1, long var3, byte var5);

    public final void putByteArray(long address, byte[] data, int offset, int length) {
        this.foreign.putByteArray(address, data, offset, length);
    }

    public final void getByteArray(long address, byte[] data, int offset, int length) {
        this.foreign.getByteArray(address, data, offset, length);
    }

    public final void putCharArray(long address, char[] data, int offset, int length) {
        this.foreign.putCharArray(address, data, offset, length);
    }

    public final void getCharArray(long address, char[] data, int offset, int length) {
        this.foreign.getCharArray(address, data, offset, length);
    }

    public final void putShortArray(long address, short[] data, int offset, int length) {
        this.foreign.putShortArray(address, data, offset, length);
    }

    public final void getShortArray(long address, short[] data, int offset, int length) {
        this.foreign.getShortArray(address, data, offset, length);
    }

    public final void putIntArray(long address, int[] data, int offset, int length) {
        this.foreign.putIntArray(address, data, offset, length);
    }

    public final void getIntArray(long address, int[] data, int offset, int length) {
        this.foreign.getIntArray(address, data, offset, length);
    }

    public final void getLongArray(long address, long[] data, int offset, int length) {
        this.foreign.getLongArray(address, data, offset, length);
    }

    public final void putLongArray(long address, long[] data, int offset, int length) {
        this.foreign.putLongArray(address, data, offset, length);
    }

    public final void getFloatArray(long address, float[] data, int offset, int length) {
        this.foreign.getFloatArray(address, data, offset, length);
    }

    public final void putFloatArray(long address, float[] data, int offset, int length) {
        this.foreign.putFloatArray(address, data, offset, length);
    }

    public final void getDoubleArray(long address, double[] data, int offset, int length) {
        this.foreign.getDoubleArray(address, data, offset, length);
    }

    public final void putDoubleArray(long address, double[] data, int offset, int length) {
        this.foreign.putDoubleArray(address, data, offset, length);
    }

    public final long allocateMemory(long size, boolean clear) {
        return this.foreign.allocateMemory(size, clear);
    }

    public final void freeMemory(long address) {
        this.foreign.freeMemory(address);
    }

    public final long getStringLength(long address) {
        return this.foreign.strlen(address);
    }

    public final long indexOf(long address, byte value) {
        return this.foreign.memchr(address, value, Integer.MAX_VALUE);
    }

    public final long indexOf(long address, byte value, int maxlen) {
        return this.foreign.memchr(address, value, maxlen);
    }

    private static final void verifyAccessor(Class unsafeClass, Class primitive) throws NoSuchMethodException {
        String primitiveName = primitive.getSimpleName();
        String typeName = primitiveName.substring(0, 1).toUpperCase() + primitiveName.substring(1);
        Method get = unsafeClass.getDeclaredMethod("get" + typeName, Long.TYPE);
        if (!get.getReturnType().equals(primitive)) {
            throw new NoSuchMethodException("Incorrect return type for " + get.getName());
        }
        unsafeClass.getDeclaredMethod("put" + typeName, Long.TYPE, primitive);
    }

    static final boolean isUnsafeAvailable() {
        try {
            Class[] primitiveTypes;
            Class<?> sunClass = Class.forName("sun.misc.Unsafe");
            for (Class type : primitiveTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                MemoryIO.verifyAccessor(sunClass, type);
            }
            sunClass.getDeclaredMethod("getAddress", Long.TYPE);
            sunClass.getDeclaredMethod("putAddress", Long.TYPE, Long.TYPE);
            sunClass.getDeclaredMethod("allocateMemory", Long.TYPE);
            sunClass.getDeclaredMethod("freeMemory", Long.TYPE);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static /* synthetic */ MemoryIO access$000() {
        return MemoryIO.getImpl();
    }

    private static final class UnsafeImpl64
    extends UnsafeImpl {
        private UnsafeImpl64() {
        }

        public final long getAddress(long address) {
            return unsafe.getAddress(address);
        }

        public final void putAddress(long address, long value) {
            unsafe.putAddress(address, value);
        }
    }

    private static final class UnsafeImpl32
    extends UnsafeImpl {
        private UnsafeImpl32() {
        }

        public final long getAddress(long address) {
            return unsafe.getAddress(address) & ADDRESS_MASK;
        }

        public final void putAddress(long address, long value) {
            unsafe.putAddress(address, value & ADDRESS_MASK);
        }
    }

    private static abstract class UnsafeImpl
    extends MemoryIO {
        protected static Unsafe unsafe = (Unsafe)Unsafe.class.cast(UnsafeImpl.getUnsafe());

        private UnsafeImpl() {
        }

        private static final Object getUnsafe() {
            try {
                Class<?> sunUnsafe = Class.forName("sun.misc.Unsafe");
                Field f = sunUnsafe.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return f.get(sunUnsafe);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public final byte getByte(long address) {
            return unsafe.getByte(address);
        }

        public final short getShort(long address) {
            return unsafe.getShort(address);
        }

        public final int getInt(long address) {
            return unsafe.getInt(address);
        }

        public final long getLong(long address) {
            return unsafe.getLong(address);
        }

        public final float getFloat(long address) {
            return unsafe.getFloat(address);
        }

        public final double getDouble(long address) {
            return unsafe.getDouble(address);
        }

        public final void putByte(long address, byte value) {
            unsafe.putByte(address, value);
        }

        public final void putShort(long address, short value) {
            unsafe.putShort(address, value);
        }

        public final void putInt(long address, int value) {
            unsafe.putInt(address, value);
        }

        public final void putLong(long address, long value) {
            unsafe.putLong(address, value);
        }

        public final void putFloat(long address, float value) {
            unsafe.putFloat(address, value);
        }

        public final void putDouble(long address, double value) {
            unsafe.putDouble(address, value);
        }

        public final void copyMemory(long src, long dst, long size) {
            unsafe.copyMemory(src, dst, size);
        }

        public final void setMemory(long src, long size, byte value) {
            unsafe.setMemory(src, size, value);
        }
    }

    private static final class NativeImpl64
    extends NativeImpl {
        private NativeImpl64() {
        }

        public final long getAddress(long address) {
            return foreign.getAddress(address);
        }

        public final void putAddress(long address, long value) {
            foreign.putAddress(address, value);
        }
    }

    private static final class NativeImpl32
    extends NativeImpl {
        private NativeImpl32() {
        }

        public final long getAddress(long address) {
            return foreign.getAddress(address) & ADDRESS_MASK;
        }

        public final void putAddress(long address, long value) {
            foreign.putAddress(address, value & ADDRESS_MASK);
        }
    }

    private static abstract class NativeImpl
    extends MemoryIO {
        protected static final Foreign foreign = Foreign.getInstance();

        private NativeImpl() {
        }

        public final byte getByte(long address) {
            return foreign.getByte(address);
        }

        public final short getShort(long address) {
            return foreign.getShort(address);
        }

        public final int getInt(long address) {
            return foreign.getInt(address);
        }

        public final long getLong(long address) {
            return foreign.getLong(address);
        }

        public final float getFloat(long address) {
            return foreign.getFloat(address);
        }

        public final double getDouble(long address) {
            return foreign.getDouble(address);
        }

        public final void putByte(long address, byte value) {
            foreign.putByte(address, value);
        }

        public final void putShort(long address, short value) {
            foreign.putShort(address, value);
        }

        public final void putInt(long address, int value) {
            foreign.putInt(address, value);
        }

        public final void putLong(long address, long value) {
            foreign.putLong(address, value);
        }

        public final void putFloat(long address, float value) {
            foreign.putFloat(address, value);
        }

        public final void putDouble(long address, double value) {
            foreign.putDouble(address, value);
        }

        public final void setMemory(long address, long size, byte value) {
            foreign.setMemory(address, size, value);
        }

        public final void copyMemory(long src, long dst, long size) {
            foreign.copyMemory(src, dst, size);
        }
    }

    private static final class SingletonHolder {
        private static final MemoryIO INSTANCE = MemoryIO.access$000();

        private SingletonHolder() {
        }
    }
}

