/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.Platform;

public abstract class Invoker {
    private static final long ADDRESS_SIZE = Platform.getPlatform().addressSize();
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();
    final Foreign foreign = Foreign.getInstance();

    public static final Invoker getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private Invoker() {
    }

    public abstract int invokeVrI(Function var1);

    public abstract int invokeIrI(Function var1, int var2);

    public abstract int invokeIIrI(Function var1, int var2, int var3);

    public abstract int invokeIIIrI(Function var1, int var2, int var3, int var4);

    public abstract long invokeAddress(Function var1, HeapInvocationBuffer var2);

    public final long invokeVrL(Function function) {
        return this.foreign.invokeVrL(function.getAddress64());
    }

    public final long invokeLrL(Function function, long arg1) {
        return this.foreign.invokeLrL(function.getAddress64(), arg1);
    }

    public final long invokeLLrL(Function function, long arg1, long arg2) {
        return this.foreign.invokeLLrL(function.getAddress64(), arg1, arg2);
    }

    public final long invokeLLLrL(Function function, long arg1, long arg2, long arg3) {
        return this.foreign.invokeLLLrL(function.getAddress64(), arg1, arg2, arg3);
    }

    public final int invokeInt(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.invokeArrayWithObjectsInt32(function, buffer, objectBuffer) : this.foreign.invokeArrayInt32(function.getAddress64(), buffer.array());
    }

    public final long invokeLong(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsInt64(function.getAddress64(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayInt64(function.getAddress64(), buffer.array());
    }

    public final float invokeFloat(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsFloat(function.getAddress64(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayFloat(function.getAddress64(), buffer.array());
    }

    public final double invokeDouble(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsDouble(function.getAddress64(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayDouble(function.getAddress64(), buffer.array());
    }

    private final int invokeArrayWithObjectsInt32(Function function, HeapInvocationBuffer buffer, ObjectBuffer objectBuffer) {
        Object[] objects = objectBuffer.objects();
        int[] info = objectBuffer.info();
        int objectCount = objectBuffer.objectCount();
        switch (objectCount) {
            case 1: {
                return this.foreign.invokeArrayO1Int32(function.getAddress64(), buffer.array(), objects[0], info[0], info[1], info[2]);
            }
            case 2: {
                return this.foreign.invokeArrayO2Int32(function.getAddress64(), buffer.array(), objects[0], info[0], info[1], info[2], objects[1], info[3], info[4], info[5]);
            }
        }
        return this.foreign.invokeArrayWithObjectsInt32(function.getAddress64(), buffer.array(), objectCount, info, objects);
    }

    private static final Invoker getILP32() {
        return ILP32.INSTANCE;
    }

    private static final Invoker getLP64() {
        return LP64.INSTANCE;
    }

    static /* synthetic */ long access$000() {
        return ADDRESS_SIZE;
    }

    static /* synthetic */ Invoker access$100() {
        return Invoker.getLP64();
    }

    static /* synthetic */ Invoker access$200() {
        return Invoker.getILP32();
    }

    private static final class LP64
    extends Invoker {
        private static final Invoker INSTANCE = new LP64();

        private LP64() {
        }

        public final int invokeVrI(Function function) {
            return this.foreign.invoke64VrI(function.getAddress64());
        }

        public int invokeIrI(Function function, int arg1) {
            return this.foreign.invoke64IrI(function.getAddress64(), arg1);
        }

        public int invokeIIrI(Function function, int arg1, int arg2) {
            return this.foreign.invoke64IIrI(function.getAddress64(), arg2, arg1);
        }

        public int invokeIIIrI(Function function, int arg1, int arg2, int arg3) {
            return this.foreign.invoke64IIIrI(function.getAddress64(), arg1, arg2, arg3);
        }

        public long invokeAddress(Function function, HeapInvocationBuffer buffer) {
            return this.invokeLong(function, buffer);
        }
    }

    private static final class ILP32
    extends Invoker {
        private static final Invoker INSTANCE = new ILP32();

        private ILP32() {
        }

        public final int invokeVrI(Function function) {
            return this.foreign.invoke32VrI(function.getAddress32());
        }

        public final int invokeIrI(Function function, int arg1) {
            return this.foreign.invoke32IrI(function.getAddress32(), arg1);
        }

        public final int invokeIIrI(Function function, int arg1, int arg2) {
            return this.foreign.invoke32IIrI(function.getAddress32(), arg2, arg1);
        }

        public final int invokeIIIrI(Function function, int arg1, int arg2, int arg3) {
            return this.foreign.invoke32IIIrI(function.getAddress32(), arg1, arg2, arg3);
        }

        public final long invokeAddress(Function function, HeapInvocationBuffer buffer) {
            return (long)this.invokeInt(function, buffer) & ADDRESS_MASK;
        }
    }

    private static final class SingletonHolder {
        private static final Invoker INSTANCE = Invoker.access$000() == 64L ? Invoker.access$100() : Invoker.access$200();

        private SingletonHolder() {
        }
    }
}

