/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.annotations.In;
import com.kenai.jaffl.annotations.NulTerminate;
import com.kenai.jaffl.annotations.Out;
import com.kenai.jaffl.annotations.Pinned;
import com.kenai.jaffl.annotations.Transient;
import java.lang.annotation.Annotation;

public final class ParameterFlags {
    public static final int OUT = 1;
    public static final int IN = 2;
    public static final int TRANSIENT = 4;
    public static final int PINNED = 8;
    public static final int NULTERMINATE = 16;

    private ParameterFlags() {
    }

    public static final int parse(Annotation[] annotations) {
        int flags = 0;
        for (Annotation a : annotations) {
            flags |= a instanceof Out ? 1 : 0;
            flags |= a instanceof In ? 2 : 0;
            flags |= a instanceof Transient ? 4 : 0;
            flags |= a instanceof Pinned ? 8 : 0;
            flags |= a instanceof NulTerminate ? 16 : 0;
        }
        return flags;
    }

    public static final boolean isFlag(Annotation annotation) {
        return annotation instanceof Pinned || annotation instanceof Transient || annotation instanceof NulTerminate || annotation instanceof Out || annotation instanceof In;
    }

    public static final boolean isPinned(int flags) {
        return (flags & 8) != 0;
    }

    public static final boolean isTransient(int flags) {
        return (flags & 4) != 0;
    }

    public static final boolean isNulTerminate(int flags) {
        return (flags & 0x10) != 0;
    }

    public static final boolean isOut(int flags) {
        return (flags & 3) != 2;
    }

    public static final boolean isIn(int flags) {
        return (flags & 3) != 1;
    }
}

