/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jruby.dirgra.DataIterable;
import org.jruby.dirgra.DirectedGraph;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.EdgeTypeIterable;
import org.jruby.dirgra.ExplicitVertexID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vertex<T>
implements Comparable<Vertex<T>> {
    private DirectedGraph graph;
    private T data;
    private Set<Edge<T>> incoming = null;
    private Set<Edge<T>> outgoing = null;
    int id;

    public Vertex(DirectedGraph graph, T data, int id) {
        this.graph = graph;
        this.data = data;
        this.id = id;
    }

    public void addEdgeTo(Vertex destination) {
        this.addEdgeTo(destination, (Object)null);
    }

    public void addEdgeTo(Vertex destination, Object type) {
        Edge edge = new Edge(this, destination, type);
        this.getOutgoingEdges().add(edge);
        destination.getIncomingEdges().add(edge);
        this.graph.edges().add(edge);
    }

    public void addEdgeTo(T destination) {
        this.addEdgeTo(destination, null);
    }

    public void addEdgeTo(T destination, Object type) {
        Vertex<T> destinationVertex = this.graph.findOrCreateVertexFor(destination);
        this.addEdgeTo(destinationVertex, type);
    }

    public boolean removeEdgeTo(Vertex destination) {
        for (Edge<T> edge : this.getOutgoingEdges()) {
            if (edge.getDestination() != destination) continue;
            this.getOutgoingEdges().remove(edge);
            edge.getDestination().getIncomingEdges().remove(edge);
            this.graph.edges().remove(edge);
            if (this.outDegree() == 0) {
                this.outgoing = null;
            }
            if (destination.inDegree() == 0) {
                destination.incoming = null;
            }
            return true;
        }
        return false;
    }

    public void removeAllIncomingEdges() {
        for (Edge<T> edge : this.getIncomingEdges()) {
            edge.getSource().getOutgoingEdges().remove(edge);
            this.graph.edges().remove(edge);
        }
        this.incoming = null;
    }

    public void removeAllOutgoingEdges() {
        for (Edge<T> edge : this.getOutgoingEdges()) {
            edge.getDestination().getIncomingEdges().remove(edge);
            this.graph.edges().remove(edge);
        }
        this.outgoing = null;
    }

    public void removeAllEdges() {
        this.removeAllIncomingEdges();
        this.removeAllOutgoingEdges();
    }

    public int inDegree() {
        return this.incoming == null ? 0 : this.incoming.size();
    }

    public int outDegree() {
        return this.outgoing == null ? 0 : this.outgoing.size();
    }

    public Iterable<Edge<T>> getIncomingEdgesOfType(Object type) {
        return new EdgeTypeIterable<T>(this.getIncomingEdges(), type);
    }

    public Iterable<Edge<T>> getIncomingEdgesNotOfType(Object type) {
        return new EdgeTypeIterable<T>(this.getIncomingEdges(), type, true);
    }

    public Iterable<Edge<T>> getOutgoingEdgesOfType(Object type) {
        return new EdgeTypeIterable<T>(this.getOutgoingEdges(), type);
    }

    public T getIncomingSourceData() {
        Edge<T> edge = this.getFirstEdge(this.getIncomingEdges().iterator());
        return edge == null ? null : (T)edge.getSource().getData();
    }

    public T getIncomingSourceDataOfType(Object type) {
        Edge<T> edge = this.getFirstEdge(this.getIncomingEdgesOfType(type).iterator());
        return edge == null ? null : (T)edge.getSource().getData();
    }

    public Iterable<T> getIncomingSourcesData() {
        return new DataIterable<T>(this.getIncomingEdges(), null, true, true);
    }

    public Iterable<T> getIncomingSourcesDataOfType(Object type) {
        return new DataIterable<T>(this.getIncomingEdges(), type, true, false);
    }

    public Iterable<T> getIncomingSourcesDataNotOfType(Object type) {
        return new DataIterable<T>(this.getIncomingEdges(), type, true, true);
    }

    public Iterable<Edge<T>> getOutgoingEdgesNotOfType(Object type) {
        return new EdgeTypeIterable<T>(this.getOutgoingEdges(), type, true);
    }

    public Iterable<T> getOutgoingDestinationsData() {
        return new DataIterable<T>(this.getOutgoingEdges(), null, false, true);
    }

    public Iterable<T> getOutgoingDestinationsDataOfType(Object type) {
        return new DataIterable<T>(this.getOutgoingEdges(), type, false, false);
    }

    public Iterable<T> getOutgoingDestinationsDataNotOfType(Object type) {
        return new DataIterable<T>(this.getOutgoingEdges(), type, false, true);
    }

    public T getOutgoingDestinationData() {
        Edge<T> edge = this.getFirstEdge(this.getOutgoingEdges().iterator());
        return edge == null ? null : (T)edge.getDestination().getData();
    }

    public T getOutgoingDestinationDataOfType(Object type) {
        Edge<T> edge = this.getFirstEdge(this.getOutgoingEdgesOfType(type).iterator());
        return edge == null ? null : (T)edge.getDestination().getData();
    }

    private Edge<T> getFirstEdge(Iterator<Edge<T>> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    public Edge<T> getIncomingEdgeOfType(Object type) {
        return this.getFirstEdge(this.getIncomingEdgesOfType(type).iterator());
    }

    public Edge<T> getOutgoingEdgeOfType(Object type) {
        return this.getFirstEdge(this.getOutgoingEdgesOfType(type).iterator());
    }

    public Edge<T> getIncomingEdge() {
        return this.getFirstEdge(this.getIncomingEdgesNotOfType(null).iterator());
    }

    public Edge<T> getOutgoingEdge() {
        return this.getFirstEdge(this.getOutgoingEdgesNotOfType(null).iterator());
    }

    public Set<Edge<T>> getIncomingEdges() {
        if (this.incoming == null) {
            this.incoming = new HashSet<Edge<T>>();
        }
        return this.incoming;
    }

    public Set<Edge<T>> getOutgoingEdges() {
        if (this.outgoing == null) {
            this.outgoing = new HashSet<Edge<T>>();
        }
        return this.outgoing;
    }

    public T getData() {
        return this.data;
    }

    public int getID() {
        return this.data instanceof ExplicitVertexID ? ((ExplicitVertexID)this.data).getID() : this.id;
    }

    public String toString() {
        int i;
        ArrayList<Edge<T>> e;
        boolean found = false;
        StringBuilder buf = new StringBuilder(this.data.toString());
        buf.append(":");
        Set<Edge<T>> edges = this.getOutgoingEdges();
        int size = edges.size();
        if (size > 0) {
            found = true;
            buf.append(">[");
            e = new ArrayList<Edge<T>>(edges);
            Collections.sort(e, new DestinationCompare());
            for (i = 0; i < size - 1; ++i) {
                buf.append(((Edge)e.get(i)).getDestination().getID()).append(",");
            }
            buf.append(((Edge)e.get(size - 1)).getDestination().getID()).append("]");
        }
        if ((size = (edges = this.getIncomingEdges()).size()) > 0) {
            if (found) {
                buf.append(", ");
            }
            buf.append("<[");
            e = new ArrayList<Edge<T>>(edges);
            Collections.sort(e, new SourceCompare());
            for (i = 0; i < size - 1; ++i) {
                buf.append(((Edge)e.get(i)).getSource().getID()).append(",");
            }
            buf.append(((Edge)e.get(size - 1)).getSource().getID()).append("]");
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public int compareTo(Vertex<T> that) {
        if (this.getID() == that.getID()) {
            return 0;
        }
        if (this.getID() < that.getID()) {
            return -1;
        }
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DestinationCompare
    implements Comparator<Edge<T>> {
        DestinationCompare() {
        }

        @Override
        public int compare(Edge<T> o1, Edge<T> o2) {
            int i2;
            int i1 = o1.getDestination().getID();
            if (i1 == (i2 = o2.getDestination().getID())) {
                return 0;
            }
            return i1 < i2 ? -1 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SourceCompare
    implements Comparator<Edge<T>> {
        SourceCompare() {
        }

        @Override
        public int compare(Edge<T> o1, Edge<T> o2) {
            int i2;
            int i1 = o1.getSource().getID();
            if (i1 == (i2 = o2.getSource().getID())) {
                return 0;
            }
            return i1 < i2 ? -1 : 1;
        }
    }
}

