/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jprocesses.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessesUtils {
    private static final String CRLF = "\r\n";

    private ProcessesUtils() {
    }

    public static String executeCommand(String ... command) {
        String commandOutput = null;
        try {
            Process process = Runtime.getRuntime().exec(command);
            commandOutput = ProcessesUtils.readData(process);
        }
        catch (IOException ex) {
            Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return commandOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readData(Process process) {
        StringBuilder commandOutput = new StringBuilder();
        BufferedReader processOutput = null;
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            String line;
            processOutput = process.exitValue() == 0 ? new BufferedReader(new InputStreamReader(process.getInputStream())) : new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = processOutput.readLine()) != null) {
                if (line.isEmpty()) continue;
                commandOutput.append(line).append(CRLF);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (processOutput != null) {
                    processOutput.close();
                }
            }
            catch (IOException ioe) {
                Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ioe);
            }
        }
        return commandOutput.toString();
    }

    public static int executeCommandAndGetCode(String ... command) {
        Process process;
        try {
            process = Runtime.getRuntime().exec(command);
            process.waitFor();
        }
        catch (IOException ex) {
            Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
        return process.exitValue();
    }
}

