/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.ast.declaration;

import java.util.List;
import org.jparsec.examples.common.Strings;
import org.jparsec.examples.common.ValueObject;
import org.jparsec.examples.java.ast.declaration.Declaration;
import org.jparsec.examples.java.ast.declaration.DefBody;
import org.jparsec.examples.java.ast.declaration.TypeParameterDef;
import org.jparsec.examples.java.ast.statement.Modifier;
import org.jparsec.examples.java.ast.type.TypeLiteral;

public final class InterfaceDef
extends ValueObject
implements Declaration {
    public final List<Modifier> modifiers;
    public final String name;
    public final List<TypeParameterDef> typeParameters;
    public final List<TypeLiteral> interfaces;
    public final DefBody body;

    public InterfaceDef(List<Modifier> modifiers, String name, List<TypeParameterDef> typeParameters, List<TypeLiteral> interfaces, DefBody body) {
        this.modifiers = modifiers;
        this.name = name;
        this.typeParameters = typeParameters;
        this.interfaces = interfaces;
        this.body = body;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Modifier modifier : this.modifiers) {
            builder.append(modifier).append(' ');
        }
        builder.append("interface ").append(this.name);
        if (this.typeParameters != null) {
            builder.append('<');
            Strings.join(builder, ", ", this.typeParameters);
            builder.append('>');
        }
        if (this.interfaces != null) {
            builder.append(" extends ");
            Strings.join(builder, ", ", this.interfaces);
        }
        builder.append(' ').append(this.body);
        return builder.toString();
    }
}

