/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Terminals;
import org.jparsec.examples.java.ast.declaration.AnnotationDef;
import org.jparsec.examples.java.ast.declaration.ClassDef;
import org.jparsec.examples.java.ast.declaration.ClassInitializerDef;
import org.jparsec.examples.java.ast.declaration.ConstructorDef;
import org.jparsec.examples.java.ast.declaration.Declaration;
import org.jparsec.examples.java.ast.declaration.DefBody;
import org.jparsec.examples.java.ast.declaration.EnumDef;
import org.jparsec.examples.java.ast.declaration.FieldDef;
import org.jparsec.examples.java.ast.declaration.Import;
import org.jparsec.examples.java.ast.declaration.InterfaceDef;
import org.jparsec.examples.java.ast.declaration.Member;
import org.jparsec.examples.java.ast.declaration.MethodDef;
import org.jparsec.examples.java.ast.declaration.NestedDef;
import org.jparsec.examples.java.ast.declaration.Program;
import org.jparsec.examples.java.ast.declaration.QualifiedName;
import org.jparsec.examples.java.ast.declaration.TypeParameterDef;
import org.jparsec.examples.java.ast.expression.Expression;
import org.jparsec.examples.java.ast.statement.Modifier;
import org.jparsec.examples.java.ast.statement.Statement;
import org.jparsec.examples.java.ast.type.TypeLiteral;
import org.jparsec.examples.java.parser.ExpressionParser;
import org.jparsec.examples.java.parser.StatementParser;
import org.jparsec.examples.java.parser.TerminalParser;
import org.jparsec.examples.java.parser.TypeLiteralParser;

public final class DeclarationParser {
    static final Parser<TypeParameterDef> TYPE_PARAMETER = Parsers.sequence((Parser)Terminals.Identifier.PARSER, (Parser)TerminalParser.term("extends").next(TypeLiteralParser.TYPE_LITERAL).optional(), TypeParameterDef::new);
    static final Parser<List<TypeParameterDef>> TYPE_PARAMETERS = Parsers.between(TerminalParser.term("<"), (Parser)TYPE_PARAMETER.sepBy1(TerminalParser.term(",")), TerminalParser.term(">"));
    static final Parser<QualifiedName> QUALIFIED_NAME = Terminals.Identifier.PARSER.sepBy1(TerminalParser.term(".")).map(QualifiedName::new);
    static final Parser<Import> IMPORT = Parsers.sequence((Parser)TerminalParser.term("import").next(TerminalParser.term("static").succeeds()), QUALIFIED_NAME, (Parser)TerminalParser.phrase(". *").succeeds().followedBy(TerminalParser.term(";")), Import::new);
    static final Parser<QualifiedName> PACKAGE = Parsers.between(TerminalParser.term("package"), QUALIFIED_NAME, TerminalParser.term(";"));

    static Parser<DefBody> body(Parser<Member> member) {
        Parser empty = TerminalParser.term(";").retn(null);
        return Parsers.between(TerminalParser.term("{"), (Parser)empty.or(member).many().map(DeclarationParser::removeNulls), TerminalParser.term("}")).map(DefBody::new);
    }

    static <T> List<T> removeNulls(List<T> list) {
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        return list;
    }

    static Parser<Member> fieldDef(Parser<Expression> initializer) {
        return Parsers.sequence((Parser)StatementParser.modifier(initializer).many(), TypeLiteralParser.TYPE_LITERAL, (Parser)Terminals.Identifier.PARSER, (Parser)TerminalParser.term("=").next(ExpressionParser.arrayInitializerOrRegularExpression(initializer)).optional(), TerminalParser.term(";"), (modifiers, type, name, value, __) -> new FieldDef((List<Modifier>)modifiers, (TypeLiteral)type, (String)name, (Expression)value));
    }

    static Parser<Member> constructorDef(Parser<Modifier> mod, Parser<Statement> stmt) {
        return Parsers.sequence((Parser)mod.many(), (Parser)Terminals.Identifier.PARSER, (Parser)TerminalParser.term("(").next(StatementParser.parameter(mod).sepBy(TerminalParser.term(","))).followedBy(TerminalParser.term(")")), (Parser)TerminalParser.term("throws").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), StatementParser.blockStatement(stmt), ConstructorDef::new);
    }

    static Parser<Member> methodDef(Parser<Modifier> mod, Parser<Expression> defaultValue, Parser<Statement> stmt) {
        return Parsers.sequence((Parser)mod.many(), (Parser)TYPE_PARAMETERS.optional(), TypeLiteralParser.TYPE_LITERAL, (Parser)Terminals.Identifier.PARSER, (Parser)TerminalParser.term("(").next(StatementParser.parameter(mod).sepBy(TerminalParser.term(","))).followedBy(TerminalParser.term(")")), (Parser)TerminalParser.term("throws").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), (Parser)TerminalParser.term("default").next(ExpressionParser.arrayInitializerOrRegularExpression(defaultValue)).optional(), (Parser)Parsers.or(StatementParser.blockStatement(stmt), (Parser)TerminalParser.term(";").retn((Object)null)), MethodDef::new);
    }

    static Parser<Member> initializerDef(Parser<Statement> stmt) {
        return Parsers.sequence((Parser)TerminalParser.term("static").succeeds(), StatementParser.blockStatement(stmt), ClassInitializerDef::new);
    }

    static Parser<Member> nestedDef(Parser<Declaration> dec) {
        return dec.map(NestedDef::new);
    }

    static Parser<Declaration> classDef(Parser<Modifier> mod, Parser<Member> member) {
        return Parsers.sequence((Parser)mod.many(), (Parser)TerminalParser.term("class").next(Terminals.Identifier.PARSER), (Parser)TYPE_PARAMETERS.optional(), (Parser)TerminalParser.term("extends").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL).optional(), (Parser)TerminalParser.term("implements").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), DeclarationParser.body(member), ClassDef::new);
    }

    static Parser<Declaration> interfaceDef(Parser<Modifier> mod, Parser<Member> member) {
        return Parsers.sequence((Parser)mod.many(), (Parser)TerminalParser.term("interface").next(Terminals.Identifier.PARSER), (Parser)TYPE_PARAMETERS.optional(), (Parser)TerminalParser.term("extends").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), DeclarationParser.body(member), InterfaceDef::new);
    }

    static Parser<Declaration> annotationDef(Parser<Modifier> mod, Parser<Member> member) {
        return Parsers.sequence((Parser)mod.many(), (Parser)TerminalParser.phrase("@ interface").next(Terminals.Identifier.PARSER), DeclarationParser.body(member), AnnotationDef::new);
    }

    static Parser<Declaration> enumDef(Parser<Expression> expr, Parser<Member> member) {
        Parser enumValue = Parsers.sequence((Parser)Terminals.Identifier.PARSER, (Parser)Parsers.between(TerminalParser.term("("), (Parser)expr.sepBy(TerminalParser.term(",")), TerminalParser.term(")")).optional(), (Parser)Parsers.between(TerminalParser.term("{"), (Parser)member.many(), TerminalParser.term("}")).optional(), EnumDef.Value::new);
        return Parsers.sequence((Parser)StatementParser.modifier(expr).many(), (Parser)TerminalParser.term("enum").next(Terminals.Identifier.PARSER), (Parser)TerminalParser.term("implements").next(TypeLiteralParser.ELEMENT_TYPE_LITERAL.sepBy1(TerminalParser.term(","))).optional(), (Parser)TerminalParser.term("{").next(enumValue.sepBy(TerminalParser.term(","))), (Parser)TerminalParser.term(";").next(member.many()).optional().followedBy(TerminalParser.term("}")), EnumDef::new);
    }

    public static Parser<Program> program() {
        Parser.Reference memberRef = Parser.newReference();
        Parser.Reference stmtRef = Parser.newReference();
        Parser<Expression> expr = ExpressionParser.expression(DeclarationParser.body((Parser<Member>)memberRef.lazy()), (Parser<Statement>)stmtRef.lazy());
        Parser<Statement> stmt = StatementParser.statement(expr);
        stmtRef.set(stmt);
        Parser<Modifier> mod = StatementParser.modifier(expr);
        Parser.Reference decRef = Parser.newReference();
        Parser member = Parsers.or(DeclarationParser.fieldDef(expr), DeclarationParser.methodDef(mod, expr, stmt), DeclarationParser.constructorDef(mod, stmt), DeclarationParser.initializerDef(stmt), DeclarationParser.nestedDef((Parser<Declaration>)decRef.lazy()));
        memberRef.set((Object)member);
        Parser declaration = Parsers.or(DeclarationParser.classDef(mod, (Parser<Member>)member), DeclarationParser.interfaceDef(mod, (Parser<Member>)member), DeclarationParser.enumDef(expr, (Parser<Member>)member), DeclarationParser.annotationDef(mod, (Parser<Member>)member));
        decRef.set((Object)declaration);
        return Parsers.sequence((Parser)PACKAGE.optional(), (Parser)IMPORT.many(), (Parser)declaration.many(), Program::new);
    }

    public static Program parse(String source) {
        return TerminalParser.parse(DeclarationParser.program(), source);
    }

    public static Program parse(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            Program program = TerminalParser.parse(DeclarationParser.program(), new InputStreamReader(in, Charset.forName("UTF-8")), url.toString());
            return program;
        }
    }
}

