/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.ast.statement;

import java.util.List;
import org.codehaus.jparsec.examples.common.Strings;
import org.codehaus.jparsec.examples.common.ValueObject;
import org.codehaus.jparsec.examples.java.ast.statement.BlockStatement;
import org.codehaus.jparsec.examples.java.ast.statement.ParameterDef;
import org.codehaus.jparsec.examples.java.ast.statement.Statement;

public final class TryStatement
extends ValueObject
implements Statement {
    public final BlockStatement tryBlock;
    public final List<CatchBlock> catchBlocks;
    public final BlockStatement finallyBlock;

    public TryStatement(BlockStatement tryBlock, List<CatchBlock> catchBlocks, BlockStatement finallyBlock) {
        this.tryBlock = tryBlock;
        this.catchBlocks = catchBlocks;
        this.finallyBlock = finallyBlock;
    }

    @Override
    public String toString() {
        return "try " + this.tryBlock + Strings.prependEach(" ", this.catchBlocks) + (this.finallyBlock == null ? "" : " finally " + this.finallyBlock);
    }

    public static final class CatchBlock
    extends ValueObject {
        public final ParameterDef parameter;
        public final BlockStatement body;

        public CatchBlock(ParameterDef parameter, BlockStatement body) {
            this.parameter = parameter;
            this.body = body;
        }

        @Override
        public String toString() {
            return "catch (" + this.parameter + ") " + this.body;
        }
    }
}

