/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.sql.parser;

import java.util.List;
import org.codehaus.jparsec.OperatorTable;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.examples.sql.ast.BetweenExpression;
import org.codehaus.jparsec.examples.sql.ast.BinaryExpression;
import org.codehaus.jparsec.examples.sql.ast.BinaryRelationalExpression;
import org.codehaus.jparsec.examples.sql.ast.Expression;
import org.codehaus.jparsec.examples.sql.ast.FullCaseExpression;
import org.codehaus.jparsec.examples.sql.ast.FunctionExpression;
import org.codehaus.jparsec.examples.sql.ast.LikeExpression;
import org.codehaus.jparsec.examples.sql.ast.NullExpression;
import org.codehaus.jparsec.examples.sql.ast.NumberExpression;
import org.codehaus.jparsec.examples.sql.ast.Op;
import org.codehaus.jparsec.examples.sql.ast.QualifiedName;
import org.codehaus.jparsec.examples.sql.ast.QualifiedNameExpression;
import org.codehaus.jparsec.examples.sql.ast.Relation;
import org.codehaus.jparsec.examples.sql.ast.SimpleCaseExpression;
import org.codehaus.jparsec.examples.sql.ast.StringExpression;
import org.codehaus.jparsec.examples.sql.ast.TupleExpression;
import org.codehaus.jparsec.examples.sql.ast.UnaryExpression;
import org.codehaus.jparsec.examples.sql.ast.UnaryRelationalExpression;
import org.codehaus.jparsec.examples.sql.ast.WildcardExpression;
import org.codehaus.jparsec.examples.sql.parser.TerminalParser;
import org.codehaus.jparsec.functors.Binary;
import org.codehaus.jparsec.functors.Pair;
import org.codehaus.jparsec.functors.Unary;
import org.codehaus.jparsec.misc.Mapper;

public final class ExpressionParser {
    static final Parser<Expression> NULL = TerminalParser.term("null").retn((Object)NullExpression.instance);
    static final Parser<Expression> NUMBER = ExpressionParser.curry(NumberExpression.class, new Object[0]).sequence(new Parser[]{TerminalParser.NUMBER});
    static final Parser<Expression> QUALIFIED_NAME = ExpressionParser.curry(QualifiedNameExpression.class, new Object[0]).sequence(new Parser[]{TerminalParser.QUALIFIED_NAME});
    static final Parser<Expression> QUALIFIED_WILDCARD = ExpressionParser.curry(WildcardExpression.class, new Object[0]).sequence(new Parser[]{TerminalParser.QUALIFIED_NAME, TerminalParser.phrase(". *")});
    static final Parser<Expression> WILDCARD = TerminalParser.term("*").retn((Object)new WildcardExpression(QualifiedName.of(new String[0]))).or(QUALIFIED_WILDCARD);
    static final Parser<Expression> STRING = ExpressionParser.curry(StringExpression.class, new Object[0]).sequence(new Parser[]{TerminalParser.STRING});

    static Parser<Expression> functionCall(Parser<Expression> param) {
        return ExpressionParser.curry(FunctionExpression.class, new Object[0]).sequence(new Parser[]{TerminalParser.QUALIFIED_NAME, TerminalParser.term("("), param.sepBy(TerminalParser.term(",")), TerminalParser.term(")")});
    }

    static Parser<Expression> tuple(Parser<Expression> expr) {
        return ExpressionParser.curry(TupleExpression.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("("), expr.sepBy(TerminalParser.term(",")), TerminalParser.term(")")});
    }

    static Parser<Expression> simpleCase(Parser<Expression> expr) {
        return ExpressionParser.curry(SimpleCaseExpression.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("case"), expr, ExpressionParser.whenThens(expr, expr), TerminalParser.term("else").next(expr).optional(), TerminalParser.term("end")});
    }

    static Parser<Expression> fullCase(Parser<Expression> cond, Parser<Expression> expr) {
        return ExpressionParser.curry(FullCaseExpression.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("case"), ExpressionParser.whenThens(cond, expr), TerminalParser.term("else").next(expr).optional(), TerminalParser.term("end")});
    }

    private static Parser<List<Pair<Expression, Expression>>> whenThens(Parser<Expression> cond, Parser<Expression> expr) {
        return Parsers.pair((Parser)TerminalParser.term("when").next(cond), (Parser)TerminalParser.term("then").next(expr)).many1();
    }

    static <T> Parser<T> paren(Parser<T> parser) {
        return parser.between(TerminalParser.term("("), TerminalParser.term(")"));
    }

    static Parser<Expression> arithmetic(Parser<Expression> atom) {
        Parser.Reference reference = Parser.newReference();
        Parser operand = Parsers.or(ExpressionParser.paren(reference.lazy()), ExpressionParser.functionCall((Parser<Expression>)reference.lazy()), atom);
        Parser parser = new OperatorTable().infixl(ExpressionParser.binary("+", Op.PLUS), 10).infixl(ExpressionParser.binary("-", Op.MINUS), 10).infixl(ExpressionParser.binary("*", Op.MUL), 20).infixl(ExpressionParser.binary("/", Op.DIV), 20).infixl(ExpressionParser.binary("%", Op.MOD), 20).prefix(ExpressionParser.unary("-", Op.NEG), 50).build(operand);
        reference.set((Object)parser);
        return parser;
    }

    static Parser<Expression> expression(Parser<Expression> cond) {
        Parser.Reference reference = Parser.newReference();
        Parser lazyExpr = reference.lazy();
        Parser atom = Parsers.or(NUMBER, WILDCARD, QUALIFIED_NAME, ExpressionParser.simpleCase((Parser<Expression>)lazyExpr), ExpressionParser.fullCase(cond, (Parser<Expression>)lazyExpr));
        Parser expression = ExpressionParser.arithmetic((Parser<Expression>)atom).label("expression");
        reference.set((Object)expression);
        return expression;
    }

    static Parser<Expression> compare(Parser<Expression> expr) {
        return Parsers.or(ExpressionParser.compare(expr, ">", Op.GT), ExpressionParser.compare(expr, ">=", Op.GE), ExpressionParser.compare(expr, "<", Op.LT), ExpressionParser.compare(expr, "<=", Op.LE), ExpressionParser.compare(expr, "=", Op.EQ), ExpressionParser.compare(expr, "<>", Op.NE), ExpressionParser.nullCheck(expr), ExpressionParser.like(expr), ExpressionParser.between(expr));
    }

    static Parser<Expression> like(Parser<Expression> expr) {
        return ExpressionParser.curry(LikeExpression.class, new Object[0]).sequence(new Parser[]{expr, Parsers.or((Parser)TerminalParser.term("like").retn((Object)true), (Parser)TerminalParser.phrase("not like").retn((Object)false)), expr, TerminalParser.term("escape").next(expr).optional()});
    }

    static Parser<Expression> nullCheck(Parser<Expression> expr) {
        return ExpressionParser.curry(BinaryExpression.class, new Object[0]).sequence(new Parser[]{expr, TerminalParser.phrase("is not").retn((Object)Op.NOT).or(TerminalParser.phrase("is").retn((Object)Op.IS)), NULL});
    }

    static Parser<Expression> logical(Parser<Expression> expr) {
        Parser.Reference ref = Parser.newReference();
        Parser parser = new OperatorTable().prefix(ExpressionParser.unary("not", Op.NOT), 30).infixl(ExpressionParser.binary("and", Op.AND), 20).infixl(ExpressionParser.binary("or", Op.OR), 10).build(ExpressionParser.paren(ref.lazy()).or(expr)).label("logical expression");
        ref.set((Object)parser);
        return parser;
    }

    static Parser<Expression> between(Parser<Expression> expr) {
        return ExpressionParser.curry(BetweenExpression.class, new Object[0]).sequence(new Parser[]{expr, Parsers.or((Parser)TerminalParser.term("between").retn((Object)true), (Parser)TerminalParser.phrase("not between").retn((Object)false)), expr, TerminalParser.term("and"), expr});
    }

    static Parser<Expression> exists(Parser<Relation> relation) {
        return ExpressionParser.curry(UnaryRelationalExpression.class, new Object[]{Op.EXISTS}).sequence(new Parser[]{TerminalParser.term("exists"), relation});
    }

    static Parser<Expression> notExists(Parser<Relation> relation) {
        return ExpressionParser.curry(UnaryRelationalExpression.class, new Object[]{Op.NOT_EXISTS}).sequence(new Parser[]{TerminalParser.phrase("not exists"), relation});
    }

    static Parser<Expression> inRelation(Parser<Expression> expr, Parser<Relation> relation) {
        return ExpressionParser.curry(BinaryRelationalExpression.class, new Object[]{Op.IN}).sequence(new Parser[]{expr, TerminalParser.term("in"), TerminalParser.term("("), relation, TerminalParser.term(")")});
    }

    static Parser<Expression> notInRelation(Parser<Expression> expr, Parser<Relation> relation) {
        return ExpressionParser.curry(BinaryRelationalExpression.class, new Object[]{Op.NOT_IN}).sequence(new Parser[]{expr, TerminalParser.phrase("not in"), TerminalParser.term("("), relation, TerminalParser.term(")")});
    }

    static Parser<Expression> in(Parser<Expression> expr) {
        return ExpressionParser.binaryExpression(Op.IN).sequence(new Parser[]{expr, TerminalParser.term("in"), ExpressionParser.tuple(expr)});
    }

    static Parser<Expression> notIn(Parser<Expression> expr) {
        return ExpressionParser.binaryExpression(Op.NOT_IN).sequence(new Parser[]{expr, TerminalParser.phrase("not in"), ExpressionParser.tuple(expr)});
    }

    static Parser<Expression> condition(Parser<Expression> expr, Parser<Relation> rel) {
        Parser atom = Parsers.or(ExpressionParser.compare(expr), ExpressionParser.in(expr), ExpressionParser.notIn(expr), ExpressionParser.exists(rel), ExpressionParser.notExists(rel), ExpressionParser.inRelation(expr, rel), ExpressionParser.notInRelation(expr, rel));
        return ExpressionParser.logical((Parser<Expression>)atom);
    }

    private static Parser<Expression> compare(Parser<Expression> operand, String name, Op op) {
        return ExpressionParser.curry(BinaryExpression.class, new Object[0]).sequence(new Parser[]{operand, TerminalParser.term(name).retn((Object)op), operand});
    }

    private static Parser<Binary<Expression>> binary(String name, Op op) {
        return TerminalParser.term(name).next(ExpressionParser.binaryExpression(op).binary());
    }

    private static Parser<Unary<Expression>> unary(String name, Op op) {
        return TerminalParser.term(name).next(ExpressionParser.unaryExpression(op).unary());
    }

    private static Mapper<Expression> binaryExpression(Op op) {
        return ExpressionParser.curry(BinaryExpression.class, new Object[]{op});
    }

    private static Mapper<Expression> unaryExpression(Op op) {
        return ExpressionParser.curry(UnaryExpression.class, new Object[]{op});
    }

    private static Mapper<Expression> curry(Class<? extends Expression> clazz, Object ... args) {
        return Mapper.curry(clazz, (Object[])args);
    }
}

