/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.parser;

import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Scanners;
import org.codehaus.jparsec.examples.java.ast.expression.DecimalPointNumberLiteral;
import org.codehaus.jparsec.examples.java.ast.expression.IntegerLiteral;
import org.codehaus.jparsec.examples.java.ast.expression.NumberType;
import org.codehaus.jparsec.examples.java.ast.expression.ScientificNumberLiteral;
import org.codehaus.jparsec.examples.java.parser.JavaScanners;
import org.codehaus.jparsec.misc.Mapper;
import org.codehaus.jparsec.pattern.CharPredicate;
import org.codehaus.jparsec.pattern.Patterns;

public final class JavaLexer {
    private static final CharPredicate JAVA_IDENTIFIER_START = new CharPredicate(){

        public boolean isChar(char c) {
            return Character.isJavaIdentifierStart(c);
        }
    };
    private static final CharPredicate JAVA_IDENTIFIER_PART = new CharPredicate(){

        public boolean isChar(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    };
    static final Parser<String> IDENTIFIER = Patterns.isChar((CharPredicate)JAVA_IDENTIFIER_START).next(Patterns.isChar((CharPredicate)JAVA_IDENTIFIER_PART).many()).toScanner("identifier").source();
    static final Parser<Void> DECIMAL_POINT_SCANNER = Patterns.INTEGER.optional().next(Patterns.FRACTION).toScanner("decimal point number");
    static final Parser<DecimalPointNumberLiteral> DECIMAL_POINT_NUMBER = Mapper.curry(DecimalPointNumberLiteral.class, (Object[])new Object[0]).sequence(new Parser[]{DECIMAL_POINT_SCANNER.source(), JavaLexer.numberType(NumberType.DOUBLE)});
    static final Parser<IntegerLiteral> HEX_INTEGER = new Mapper<IntegerLiteral>(){

        IntegerLiteral map(String text, NumberType type) {
            return new IntegerLiteral(IntegerLiteral.Radix.HEX, text.substring(2), type);
        }
    }.sequence(new Parser[]{Scanners.HEX_INTEGER.source(), JavaLexer.numberType(NumberType.INT)});
    static final Parser<IntegerLiteral> OCT_INTEGER = new Mapper<IntegerLiteral>(){

        IntegerLiteral map(String text, NumberType type) {
            return new IntegerLiteral(IntegerLiteral.Radix.OCT, text.length() == 1 ? text : text.substring(1), type);
        }
    }.sequence(new Parser[]{JavaScanners.OCT_INTEGER.source(), JavaLexer.numberType(NumberType.INT)});
    static final Parser<IntegerLiteral> DEC_INTEGER = Mapper.curry(IntegerLiteral.class, (Object[])new Object[]{IntegerLiteral.Radix.DEC}).sequence(new Parser[]{JavaScanners.DEC_INTEGER.source(), JavaLexer.numberType(NumberType.INT)});
    static final Parser<IntegerLiteral> INTEGER = Parsers.or(HEX_INTEGER, OCT_INTEGER, DEC_INTEGER);
    static final Parser<ScientificNumberLiteral> SCIENTIFIC_NUMBER_LITERAL = Mapper.curry(ScientificNumberLiteral.class, (Object[])new Object[0]).sequence(new Parser[]{Scanners.SCIENTIFIC_NOTATION, JavaLexer.numberType(NumberType.DOUBLE)});

    static Parser<NumberType> numberType(NumberType defaultType) {
        return Parsers.or((Parser)Scanners.among((String)"lL").retn((Object)NumberType.LONG), (Parser)Scanners.among((String)"fF").retn((Object)NumberType.FLOAT), (Parser)Scanners.among((String)"dD").retn((Object)NumberType.DOUBLE), (Parser)Parsers.constant((Object)((Object)defaultType)));
    }
}

