/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.bnf.parser;

import java.util.List;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Terminals;
import org.codehaus.jparsec.examples.bnf.ast.AltRule;
import org.codehaus.jparsec.examples.bnf.ast.LiteralRule;
import org.codehaus.jparsec.examples.bnf.ast.Rule;
import org.codehaus.jparsec.examples.bnf.ast.RuleDef;
import org.codehaus.jparsec.examples.bnf.ast.RuleReference;
import org.codehaus.jparsec.examples.bnf.ast.SequentialRule;
import org.codehaus.jparsec.examples.bnf.parser.TerminalParser;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.misc.Mapper;

public final class RuleParser {
    static final Parser<Rule> LITERAL = RuleParser.curry(LiteralRule.class, new Object[0]).sequence(new Parser[]{Terminals.StringLiteral.PARSER});
    static final Parser<Rule> IDENT = RuleParser.curry(RuleReference.class, new Object[0]).sequence(new Parser[]{Terminals.Identifier.PARSER.notFollowedBy(TerminalParser.term("::="))});
    static Parser<RuleDef> RULE_DEF = Mapper.curry(RuleDef.class, (Object[])new Object[0]).sequence(new Parser[]{Terminals.Identifier.PARSER, TerminalParser.term("::="), RuleParser.rule()});
    public static Parser<List<RuleDef>> RULE_DEFS = RULE_DEF.many();

    static Parser<Rule> rule() {
        Parser.Reference ref = Parser.newReference();
        Parser atom = Parsers.or(LITERAL, IDENT, RuleParser.unit((Parser<Rule>)ref.lazy()));
        Parser<Rule> parser = RuleParser.alternative(RuleParser.sequential((Parser<Rule>)atom));
        ref.set(parser);
        return parser;
    }

    static Parser<Rule> unit(Parser<Rule> rule) {
        return Parsers.or((Parser)rule.between(TerminalParser.term("("), TerminalParser.term(")")), (Parser)rule.between(TerminalParser.INDENTATION.indent(), TerminalParser.INDENTATION.outdent()));
    }

    static Parser<Rule> sequential(Parser<Rule> rule) {
        return rule.many1().map((Map)new Map<List<Rule>, Rule>(){

            public Rule map(List<Rule> list) {
                return list.size() == 1 ? list.get(0) : new SequentialRule(list);
            }
        });
    }

    static Parser<Rule> alternative(Parser<Rule> rule) {
        return rule.sepBy1(TerminalParser.term("|")).map((Map)new Map<List<Rule>, Rule>(){

            public Rule map(List<Rule> list) {
                return list.size() == 1 ? list.get(0) : new AltRule(list);
            }
        });
    }

    private static Mapper<Rule> curry(Class<? extends Rule> ruleClass, Object ... curryArgs) {
        return Mapper.curry(ruleClass, (Object[])curryArgs);
    }
}

