/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.postgres.extensions.types;

import org.jooq.exception.DataTypeException;
import org.jooq.postgres.extensions.types.AbstractDiscreteRange;

public final class IntegerRange
extends AbstractDiscreteRange<Integer, IntegerRange> {
    private IntegerRange(Integer lower, boolean lowerIncluding, Integer upper, boolean upperIncluding) {
        super(lower, lowerIncluding, upper, upperIncluding);
    }

    public static final IntegerRange integerRange(Integer lower, Integer upper) {
        return new IntegerRange(lower, true, upper, false);
    }

    public static final IntegerRange integerRange(Integer lower, boolean lowerIncluding, Integer upper, boolean upperIncluding) {
        return new IntegerRange(lower, lowerIncluding, upper, upperIncluding);
    }

    @Override
    final IntegerRange construct(Integer lower, Integer upper) {
        return new IntegerRange(lower, true, upper, false);
    }

    @Override
    final Integer next(Integer t) {
        int l = t;
        if (l == Integer.MAX_VALUE) {
            throw new DataTypeException("Integer overflow: " + String.valueOf(this));
        }
        return l + 1;
    }

    @Override
    final Integer prev(Integer t) {
        int l = t;
        if (l == Integer.MIN_VALUE) {
            throw new DataTypeException("Integer underflow: " + String.valueOf(this));
        }
        return l - 1;
    }
}

