/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.util.Arrays;
import java.util.Locale;
import org.jooq.SQLDialect;
import org.jooq.codegen.DefaultGeneratorStrategy;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.meta.Definition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.InverseForeignKeyDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.tools.StringUtils;

public class PascalCaseGeneratorStrategy
extends DefaultGeneratorStrategy {
    @Override
    public String getJavaIdentifier(Definition definition) {
        return this.toPascalCase(this.getJavaIdentifier0(definition));
    }

    private String getJavaIdentifier0(Definition definition) {
        String identifier = this.getFixedJavaIdentifier(definition);
        if (identifier != null) {
            return identifier;
        }
        if (definition instanceof IndexDefinition && Arrays.asList(SQLDialect.MARIADB, SQLDialect.MYSQL).contains(definition.getDatabase().getDialect().family())) {
            return ((IndexDefinition)definition).getTable().getOutputName() + definition.getOutputName();
        }
        if (definition instanceof UniqueKeyDefinition && Arrays.asList(SQLDialect.SQLITE).contains(definition.getDatabase().getDialect().family())) {
            return ((UniqueKeyDefinition)definition).getTable().getOutputName() + definition.getOutputName();
        }
        if (definition instanceof ForeignKeyDefinition && Arrays.asList(SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB).contains(definition.getDatabase().getDialect().family())) {
            return ((ForeignKeyDefinition)definition).getTable().getOutputName() + definition.getOutputName();
        }
        if (definition instanceof InverseForeignKeyDefinition && Arrays.asList(SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB).contains(definition.getDatabase().getDialect().family())) {
            return ((InverseForeignKeyDefinition)definition).getReferencingTable().getOutputName() + definition.getOutputName();
        }
        if (definition instanceof EmbeddableDefinition) {
            return ((EmbeddableDefinition)definition).getReferencingOutputName();
        }
        return definition.getOutputName();
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        return StringUtils.toUC((String)super.getJavaMemberName(definition, mode), (Locale)this.targetLocale);
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        return StringUtils.toUC((String)super.getJavaMethodName(definition, mode), (Locale)this.targetLocale);
    }

    @Override
    String toPascalCase(String name) {
        switch (PascalCaseGeneratorStrategy.getCase(name)) {
            case MIXED: {
                return StringUtils.toUC((String)name, (Locale)this.targetLocale);
            }
            case LOWER: {
                return super.toPascalCase(name);
            }
        }
        return super.toPascalCase(name);
    }
}

