/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Record;
import org.jooq.codegen.AbstractDelegatingGeneratorStrategy;
import org.jooq.codegen.GenerationUtil;
import org.jooq.codegen.Generator;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.InverseForeignKeyDefinition;
import org.jooq.meta.ManyToManyKeyDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.tools.StringUtils;

class GeneratorStrategyWrapper
extends AbstractDelegatingGeneratorStrategy {
    private final Map<Class<?>, Map<Integer, Set<String>>> reservedColumns = new HashMap();
    final Generator generator;

    GeneratorStrategyWrapper(Generator generator, GeneratorStrategy delegate) {
        super(delegate);
        this.generator = generator;
    }

    @Override
    public String getJavaEnumLiteral(EnumDefinition definition, String literal) {
        Object result = this.delegate.getJavaEnumLiteral(definition, literal);
        if (((String)result).equals(this.getJavaPackageName((Definition)definition).replaceAll("\\..*", ""))) {
            result = (String)result + "_";
        }
        return result;
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        CatalogDefinition catalog;
        SchemaDefinition schema;
        String identifier = this.getFixedJavaIdentifier(definition);
        if (identifier != null) {
            return identifier;
        }
        identifier = GenerationUtil.convertToIdentifier(this.delegate.getJavaIdentifier(definition), this.getTargetLanguage());
        if (definition instanceof ColumnDefinition || definition instanceof AttributeDefinition) {
            TypedElementDefinition e = (TypedElementDefinition)definition;
            if (identifier.equals(this.getJavaIdentifier(e.getContainer()))) {
                return identifier + "_";
            }
            if (identifier.equals(this.getJavaPackageName(e.getContainer()).replaceAll("\\..*", ""))) {
                return identifier + "_";
            }
        } else if (definition instanceof TableDefinition ? identifier.equals(this.getJavaIdentifier((Definition)(schema = definition.getSchema()))) : definition instanceof SchemaDefinition && identifier.equals(this.getJavaIdentifier((Definition)(catalog = definition.getCatalog())))) {
            return identifier + "_";
        }
        identifier = this.overload(definition, GeneratorStrategy.Mode.DEFAULT, identifier);
        return identifier;
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.fixMethodName(definition, mode, this.delegate.getJavaSetterName(definition, mode));
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.fixMethodName(definition, mode, this.delegate.getJavaGetterName(definition, mode));
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        return this.fixMethodName(definition, mode, this.delegate.getJavaMethodName(definition, mode));
    }

    private String fixMethodName(Definition definition, GeneratorStrategy.Mode mode, String methodName) {
        methodName = this.overload(definition, mode, methodName);
        methodName = GenerationUtil.convertToIdentifier(methodName, this.getTargetLanguage());
        return this.disambiguateMethod(definition, mode, methodName);
    }

    private String overload(Definition definition, GeneratorStrategy.Mode mode, String identifier) {
        if (!StringUtils.isBlank((String)definition.getOverload())) {
            identifier = (String)identifier + this.getOverloadSuffix(definition, mode, definition.getOverload());
        }
        return identifier;
    }

    private String disambiguateMethod(Definition definition, GeneratorStrategy.Mode mode, String method) {
        Set<String> reserved = null;
        if (definition instanceof AttributeDefinition) {
            AttributeDefinition a = (AttributeDefinition)definition;
            reserved = new HashSet<String>(this.reservedColumns(UDTRecordImpl.class, 0));
        } else if (definition instanceof ColumnDefinition) {
            ColumnDefinition c = (ColumnDefinition)definition;
            reserved = ((TableDefinition)c.getContainer()).getPrimaryKey() != null ? this.reservedColumns(UpdatableRecordImpl.class, 0) : this.reservedColumns(TableRecordImpl.class, 0);
        } else if (definition instanceof ParameterDefinition) {
            reserved = this.reservedColumns(AbstractRoutine.class, 0);
        } else if (definition instanceof RoutineDefinition) {
            RoutineDefinition r = (RoutineDefinition)definition;
            if (r.getPackage() instanceof UDTDefinition && r.getInParameters().size() > 0 && "SELF".equalsIgnoreCase(((ParameterDefinition)r.getInParameters().get(0)).getName())) {
                reserved = this.reservedColumns(UDTRecordImpl.class, r.getInParameters().size() - 1);
            }
        } else if (definition instanceof ForeignKeyDefinition || definition instanceof InverseForeignKeyDefinition || definition instanceof ManyToManyKeyDefinition) {
            reserved = this.reservedColumns(TableImpl.class, 0);
        }
        if (reserved != null) {
            String base;
            if (reserved.contains(method)) {
                return method + "_";
            }
            if (method.startsWith("set") && (reserved.contains("get" + (base = method.substring(3))) || reserved.contains("is" + base))) {
                return method + "_";
            }
        }
        return method;
    }

    private Set<String> reservedColumns(Class<?> clazz, int length) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Map map = this.reservedColumns.computeIfAbsent(clazz, k -> new HashMap());
        HashSet<String> result = (HashSet<String>)map.get(length);
        if (result == null) {
            result = new HashSet<String>();
            map.put(length, result);
            result.addAll(this.reservedColumns(clazz.getSuperclass(), length));
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                result.addAll(this.reservedColumns(clazz2, length));
            }
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
                if (((Method)genericDeclaration).getParameterTypes().length != length) continue;
                result.add(((Method)genericDeclaration).getName());
            }
            if (this.getTargetLanguage().isScala()) {
                for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
                    result.add(((Field)annotatedElement).getName());
                }
            }
        }
        return result;
    }

    @Override
    public List<String> getJavaClassImplements(Definition definition, GeneratorStrategy.Mode mode) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.delegate.getJavaClassImplements(definition, mode));
        if (mode == GeneratorStrategy.Mode.INTERFACE && this.generator.generateSerializableInterfaces()) {
            result.add(Serializable.class.getName());
        } else if (!(mode != GeneratorStrategy.Mode.POJO || !this.generator.generateSerializablePojos() || this.generator.generateInterfaces() && this.generator.generateSerializableInterfaces())) {
            result.add(Serializable.class.getName());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public String getGlobalNamesJavaClassName(Definition container, Class<? extends Definition> objectType) {
        Object name = this.delegate.getGlobalNamesJavaClassName(container, objectType);
        if (((String)name).equals(this.delegate.getJavaClassName(container))) {
            name = (String)name + "_";
        }
        return this.fixJavaClassName((String)name);
    }

    @Override
    public String getGlobalReferencesJavaClassName(Definition container, Class<? extends Definition> objectType) {
        Object name = this.delegate.getGlobalReferencesJavaClassName(container, objectType);
        if (((String)name).equals(this.delegate.getJavaClassName(container))) {
            name = (String)name + "_";
        }
        return this.fixJavaClassName((String)name);
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String name = this.getFixedJavaClassName(definition);
        if (name != null) {
            return name;
        }
        if (definition instanceof TableDefinition && mode == GeneratorStrategy.Mode.RECORD && !this.generator.generateRecordsIncluded(definition)) {
            return Record.class.getSimpleName();
        }
        Object className = this.delegate.getJavaClassName(definition, mode);
        className = this.overload(definition, mode, (String)className);
        if (definition instanceof TableDefinition && mode == GeneratorStrategy.Mode.PATH && ((String)className).equals(this.getJavaClassName(definition))) {
            className = (String)className + "Path";
        }
        return this.fixJavaClassName((String)className);
    }

    private String fixJavaClassName(String className) {
        className = GenerationUtil.convertToIdentifier(className, this.getTargetLanguage());
        className = GenerationUtil.escapeWindowsForbiddenNames(className);
        return className;
    }

    @Override
    public String getGlobalNamesJavaPackageName(Definition container, Class<? extends Definition> objectType) {
        return this.fixJavaPackageName(this.delegate.getGlobalNamesJavaPackageName(container, objectType));
    }

    @Override
    public String getGlobalReferencesJavaPackageName(Definition container, Class<? extends Definition> objectType) {
        return this.fixJavaPackageName(this.delegate.getGlobalReferencesJavaPackageName(container, objectType));
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        if (definition instanceof TableDefinition && mode == GeneratorStrategy.Mode.RECORD && !this.generator.generateRecordsIncluded(definition)) {
            return Record.class.getPackage().getName();
        }
        return this.fixJavaPackageName(this.delegate.getJavaPackageName(definition, mode));
    }

    private String fixJavaPackageName(String packageName) {
        Object[] split = packageName.split("\\.");
        for (int i = 0; i < split.length; ++i) {
            split[i] = GenerationUtil.convertToIdentifier((String)split[i], this.getTargetLanguage());
            split[i] = GenerationUtil.escapeWindowsForbiddenNames((String)split[i]);
        }
        return StringUtils.join((Object[])split, (String)".").replaceAll("\\._?\\.", ".");
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        String identifier = GenerationUtil.convertToIdentifier(this.delegate.getJavaMemberName(definition, mode), this.getTargetLanguage());
        if (identifier.equals(this.getJavaPackageName(definition, mode).replaceAll("\\..*", ""))) {
            return identifier + "_";
        }
        return identifier;
    }
}

