/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.codegen.Language;
import org.jooq.impl.DSL;

class GenerationUtil {
    static final Pattern TYPE_REFERENCE_PATTERN = Pattern.compile("^((?:[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)((?:<.*>|\\[.*])*)$");
    static final Pattern PLAIN_GENERIC_TYPE_PATTERN = Pattern.compile("[<\\[]((?:[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)[>\\]]");
    static final Pattern UNDERSCORE_PATTERN = Pattern.compile("_+");
    private static final Set<String> JAVA_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "interface", "int", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while")));
    private static final Set<String> SCALA_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield")));
    private static final Set<String> KOTLIN_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("as", "break", "class", "continue", "do", "else", "false", "for", "fun", "if", "in", "interface", "is", "null", "object", "package", "return", "super", "this", "throw", "true", "try", "typealias", "typeof", "val", "var", "when", "while", "yield", "constructor", "init", "actual", "abstract", "annotation", "companion", "const", "crossinline", "data", "enum", "expect", "external", "final", "infix", "inline", "inner", "internal", "lateinit", "noinline", "open", "operator", "out", "override", "private", "protected", "public", "reified", "sealed", "suspend", "tailrec", "vararg")));
    private static final Set<Character> SCALA_WHITESPACE = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n'))));
    private static final Set<Character> SCALA_PARENTHESES = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'))));
    private static final Set<Character> SCALA_DELIMITER = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('`'), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('.'), Character.valueOf(';'), Character.valueOf(','))));
    private static final Set<String> WINDOWS_FORBIDDEN = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9")));

    GenerationUtil() {
    }

    private static Boolean isScalaOperator(char c) {
        return c >= ' ' && c <= '\u007f' && !Character.isLetter(c) && !Character.isDigit(c) && !SCALA_DELIMITER.contains(Character.valueOf(c)) && !SCALA_PARENTHESES.contains(Character.valueOf(c)) && !SCALA_WHITESPACE.contains(Character.valueOf(c)) || Character.getType(c) == 25 || Character.getType(c) == 28;
    }

    private static Boolean isScalaLetter(char c) {
        return Character.isLetter(c) || c == '_' || c == '$';
    }

    private static Boolean isScalaIdentifierStart(char c) {
        return GenerationUtil.isScalaLetter(c);
    }

    private static Boolean isScalaIdentifierPart(char c) {
        return GenerationUtil.isScalaIdentifierStart(c) != false || Character.isDigit(c);
    }

    private static boolean isKotlinIdentifierPart(char c) {
        return c != '\r' && c != '\n' && c != '`' && c != '(' && c != ')' && c != '{' && c != '}' && c != '[' && c != ']' && c != '.';
    }

    public static String escapeWindowsForbiddenNames(String name) {
        return name == null ? null : (WINDOWS_FORBIDDEN.contains(name.toUpperCase()) ? name + "_" : name);
    }

    public static String convertToIdentifier(String literal, Language language) {
        String result = GenerationUtil.convertToIdentifier0(literal, language);
        if (language == Language.JAVA && UNDERSCORE_PATTERN.matcher(result).matches()) {
            return result + "_";
        }
        return result;
    }

    private static String convertToIdentifier0(String literal, Language language) {
        if (language == Language.JAVA && JAVA_KEYWORDS.contains(literal)) {
            return literal + "_";
        }
        if (language == Language.SCALA && SCALA_KEYWORDS.contains(literal)) {
            return "`" + literal + "`";
        }
        if (language == Language.KOTLIN && KOTLIN_KEYWORDS.contains(literal)) {
            return "`" + literal + "`";
        }
        StringBuilder sb = new StringBuilder();
        if ("".equals(literal)) {
            if (language == Language.SCALA) {
                return "`_`";
            }
            if (language == Language.KOTLIN) {
                return "`_`";
            }
            return "_";
        }
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (language == Language.SCALA && i == literal.length() - 1 && literal.length() >= 2 && literal.charAt(i - 1) == '_' && GenerationUtil.isScalaOperator(c).booleanValue()) {
                sb.append(c);
                continue;
            }
            if (language == Language.SCALA && !GenerationUtil.isScalaIdentifierPart(c).booleanValue()) {
                sb.append(GenerationUtil.escape(c));
                continue;
            }
            if (language == Language.JAVA && !Character.isJavaIdentifierPart(c)) {
                sb.append(GenerationUtil.escape(c));
                continue;
            }
            if (language == Language.SCALA && i == 0 && !GenerationUtil.isScalaIdentifierStart(c).booleanValue()) {
                sb.append("_").append(c);
                continue;
            }
            if (language == Language.JAVA && i == 0 && !Character.isJavaIdentifierStart(c)) {
                sb.append("_").append(c);
                continue;
            }
            if (language == Language.KOTLIN && !GenerationUtil.isKotlinIdentifierPart(c)) {
                sb.append(GenerationUtil.escape(c));
                continue;
            }
            if (language == Language.KOTLIN && !Character.isJavaIdentifierPart(c)) {
                return "`" + literal + "`";
            }
            if (language == Language.KOTLIN && i == 0 && !Character.isJavaIdentifierStart(c)) {
                return "`" + literal + "`";
            }
            if (language == Language.KOTLIN && c == '$') {
                return "`" + literal + "`";
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Deprecated
    public static String convertToJavaIdentifier(String literal) {
        return GenerationUtil.convertToIdentifier(literal, Language.JAVA);
    }

    private static String escape(char c) {
        if (c == ' ' || c == '-' || c == '.') {
            return "_";
        }
        return "_" + Integer.toHexString(c);
    }

    static String getSimpleJavaType(String qualifiedJavaType) {
        if (qualifiedJavaType == null) {
            return null;
        }
        return qualifiedJavaType.replaceAll(".*\\.", "");
    }

    static Name getArrayBaseType(SQLDialect dialect, String t, Name u) {
        switch (dialect.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (u != null) {
                    if (u.last().startsWith("_")) {
                        String[] name = u.getName();
                        name[name.length - 1] = name[name.length - 1].substring(1);
                        return DSL.name((String[])name);
                    }
                    if (u.last().toUpperCase().endsWith(" ARRAY")) {
                        String[] name = u.getName();
                        name[name.length - 1] = name[name.length - 1].replaceFirst("(?i: ARRAY)", "");
                        return DSL.name((String[])name);
                    }
                }
                return u;
            }
        }
        if ("ARRAY".equalsIgnoreCase(t)) {
            return DSL.name((String)"OTHER");
        }
        return DSL.name((String)t.replaceFirst("(?i: ARRAY)", ""));
    }

    static ExpressionType expressionType(String expression) {
        if (TYPE_REFERENCE_PATTERN.matcher(expression).matches()) {
            return ExpressionType.CONSTRUCTOR_REFERENCE;
        }
        return ExpressionType.EXPRESSION;
    }

    static enum ExpressionType {
        CONSTRUCTOR_REFERENCE,
        EXPRESSION;

    }
}

