/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.client.EscapeUtil;
import org.jolokia.client.JolokiaOperation;
import org.jolokia.client.JolokiaTargetConfig;
import org.jolokia.client.request.JolokiaMBeanRequest;
import org.jolokia.client.response.JolokiaExecResponse;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;

public class JolokiaExecRequest
extends JolokiaMBeanRequest {
    private final String operation;
    private final List<Object> arguments;
    private String path;

    public JolokiaExecRequest(ObjectName pMBeanName, String pOperation, Object ... pArgs) {
        this(null, pMBeanName, pOperation, pArgs);
    }

    public JolokiaExecRequest(JolokiaTargetConfig pTargetConfig, ObjectName pMBeanName, String pOperation, Object ... pArgs) {
        super(JolokiaOperation.EXEC, pMBeanName, pTargetConfig);
        this.operation = pOperation;
        if (pArgs == null) {
            this.arguments = new ArrayList<Object>();
            this.arguments.add(null);
        } else {
            this.arguments = Arrays.asList(pArgs);
        }
    }

    public JolokiaExecRequest(String pMBeanName, String pOperation, Object ... pArgs) throws MalformedObjectNameException {
        this(null, pMBeanName, pOperation, pArgs);
    }

    public JolokiaExecRequest(JolokiaTargetConfig pTargetConfig, String pMBeanName, String pOperation, Object ... pArgs) throws MalformedObjectNameException {
        this(pTargetConfig, new ObjectName(pMBeanName), pOperation, pArgs);
    }

    public String getOperation() {
        return this.operation;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public JolokiaExecResponse createResponse(JSONObject pResponse) {
        return new JolokiaExecResponse(this, pResponse);
    }

    @Override
    public List<String> getRequestParts() {
        List<String> ret = super.getRequestParts();
        ret.add(this.operation);
        if (!this.arguments.isEmpty()) {
            for (Object argument : this.arguments) {
                ret.add(this.serializeArgumentToRequestPart(argument));
            }
        }
        ret.addAll(EscapeUtil.splitPath(this.path));
        return ret;
    }

    @Override
    public JSONObject toJson() {
        JSONObject ret = super.toJson();
        ret.put((Object)"operation", (Object)this.operation);
        if (!this.arguments.isEmpty()) {
            JSONArray args = new JSONArray(this.arguments.size());
            for (Object arg : this.arguments) {
                args.add(this.serializeArgumentToJson(arg));
            }
            ret.put((Object)"arguments", (Object)args);
        }
        if (this.path != null) {
            ret.put((Object)"path", (Object)this.path);
        }
        return ret;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String pPath) {
        this.path = pPath;
    }
}

