/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.jolokia.client.JolokiaClient;
import org.jolokia.client.JolokiaTargetConfig;
import org.jolokia.client.jdkclient.JdkHttpClientBuilder;
import org.jolokia.client.response.JolokiaResponseExtractor;
import org.jolokia.client.response.ValidatingResponseExtractor;
import org.jolokia.client.spi.HttpClientBuilder;
import org.jolokia.client.spi.HttpClientSpi;
import org.jolokia.client.spi.HttpHeader;

public class JolokiaClientBuilder {
    private static HttpClientBuilder<?> httpClientBuilder = null;
    private int connectionTimeout = 20000;
    private int socketTimeout = 0;
    private boolean tcpNoDelay = false;
    private int socketBufferSize = 8192;
    private String protocolVersion;
    private Path keystore;
    private String keystorePassword;
    private String keyPassword;
    private Path truststore;
    private String truststorePassword;
    private Charset contentCharset;
    private URI url;
    private String user;
    private String password;
    private Proxy httpProxy;
    private boolean expectContinue;
    private Collection<HttpHeader> defaultHttpHeaders;
    private String targetUrl;
    private String targetUser;
    private String targetPassword;
    private boolean pooledConnections;
    private int maxTotalConnections;
    private int maxConnectionPoolTimeout = 500;
    private Consumer<?> customizer;
    private Class<?> clientBuilderClass;
    private JolokiaResponseExtractor responseExtractor;

    public JolokiaClientBuilder() {
        this.connectionTimeout(20000);
        this.socketTimeout(-1);
        this.tcpNoDelay(false);
        this.socketBufferSize(8192);
        this.contentCharset(StandardCharsets.UTF_8.name());
        this.expectContinue(true);
        this.responseExtractor(ValidatingResponseExtractor.DEFAULT);
        this.maxTotalConnections(20);
        this.maxConnectionPoolTimeout(500);
        this.pooledConnections();
        try {
            Optional<HttpClientBuilder> clientBuilder = ServiceLoader.load(HttpClientBuilder.class).findFirst();
            if (clientBuilder.isEmpty()) {
                clientBuilder = ServiceLoader.load(HttpClientBuilder.class, null).findFirst();
            }
            httpClientBuilder = clientBuilder.orElseGet(JdkHttpClientBuilder::new);
        }
        catch (ServiceConfigurationError ignored) {
            httpClientBuilder = new JdkHttpClientBuilder();
        }
    }

    public final JolokiaClientBuilder url(String pUrl) {
        this.url = URI.create(pUrl);
        return this;
    }

    public final JolokiaClientBuilder url(URI pUrl) {
        this.url = pUrl;
        return this;
    }

    public final JolokiaClientBuilder user(String pUser) {
        this.user = pUser;
        return this;
    }

    public final JolokiaClientBuilder password(String pPassword) {
        this.password = pPassword;
        return this;
    }

    public final JolokiaClientBuilder target(String pUrl) {
        this.targetUrl = pUrl;
        return this;
    }

    public final JolokiaClientBuilder targetUser(String pUser) {
        this.targetUser = pUser;
        return this;
    }

    public final JolokiaClientBuilder targetPassword(String pPassword) {
        this.targetPassword = pPassword;
        return this;
    }

    public final JolokiaClientBuilder singleConnection() {
        this.pooledConnections = false;
        return this;
    }

    public final JolokiaClientBuilder pooledConnections() {
        this.pooledConnections = true;
        return this;
    }

    public final JolokiaClientBuilder maxTotalConnections(int pConnections) {
        this.maxTotalConnections = pConnections;
        return this;
    }

    public final JolokiaClientBuilder maxConnectionPoolTimeout(int pConnectionPoolTimeout) {
        this.maxConnectionPoolTimeout = pConnectionPoolTimeout;
        return this;
    }

    public final JolokiaClientBuilder connectionTimeout(int pTimeOut) {
        this.connectionTimeout = pTimeOut;
        return this;
    }

    public final JolokiaClientBuilder socketTimeout(int pTimeOut) {
        this.socketTimeout = pTimeOut;
        return this;
    }

    public final JolokiaClientBuilder contentCharset(String pContentCharset) {
        return this.contentCharset(Charset.forName(pContentCharset));
    }

    public final JolokiaClientBuilder contentCharset(Charset pContentCharset) {
        this.contentCharset = pContentCharset;
        return this;
    }

    public final JolokiaClientBuilder expectContinue(boolean pUse) {
        this.expectContinue = pUse;
        return this;
    }

    public final JolokiaClientBuilder tcpNoDelay(boolean pUse) {
        this.tcpNoDelay = pUse;
        return this;
    }

    public final JolokiaClientBuilder socketBufferSize(int pSize) {
        this.socketBufferSize = pSize;
        return this;
    }

    public <T> JolokiaClientBuilder withCustomizer(Class<T> builderClass, Consumer<T> customizer) {
        this.clientBuilderClass = builderClass;
        this.customizer = customizer;
        if (builderClass == null) {
            throw new IllegalArgumentException("HTTP Client Builder customizer should be associated with correct HTTP Client Builder class");
        }
        return this;
    }

    public final JolokiaClientBuilder protocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    public final JolokiaClientBuilder keystore(Path keystore) {
        this.keystore = keystore;
        return this;
    }

    public final JolokiaClientBuilder keystorePassword(String password) {
        this.keystorePassword = password;
        return this;
    }

    public final JolokiaClientBuilder keyPassword(String password) {
        this.keyPassword = password;
        return this;
    }

    public final JolokiaClientBuilder truststore(Path truststore) {
        this.truststore = truststore;
        return this;
    }

    public final JolokiaClientBuilder truststorePassword(String password) {
        this.truststorePassword = password;
        return this;
    }

    public final JolokiaClientBuilder proxy(String pProxy) {
        this.httpProxy = JolokiaClientBuilder.parseProxySettings(pProxy);
        return this;
    }

    public final JolokiaClientBuilder proxy(String pProxyHost, int pProxyPort) {
        this.httpProxy = new Proxy(pProxyHost, pProxyPort);
        return this;
    }

    public final JolokiaClientBuilder proxy(String pProxyHost, int pProxyPort, String pProxyUser, String pProxyPass) {
        this.httpProxy = new Proxy(pProxyHost, pProxyPort, pProxyUser, pProxyPass);
        return this;
    }

    public final JolokiaClientBuilder useProxyFromEnvironment() {
        Map<String, String> env = System.getenv();
        for (String key : env.keySet()) {
            if (!key.equalsIgnoreCase("http_proxy")) continue;
            this.httpProxy = JolokiaClientBuilder.parseProxySettings(env.get(key));
            break;
        }
        return this;
    }

    public final JolokiaClientBuilder responseExtractor(JolokiaResponseExtractor pResponseExtractor) {
        this.responseExtractor = pResponseExtractor;
        return this;
    }

    public final JolokiaClientBuilder setDefaultHttpHeaders(Collection<HttpHeader> pHttpHeaders) {
        this.defaultHttpHeaders = pHttpHeaders;
        return this;
    }

    public JolokiaClient build() {
        return new JolokiaClient(this.url, this.createHttpClient(), this.targetUrl != null ? new JolokiaTargetConfig(this.targetUrl, this.targetUser, this.targetPassword) : null, this.responseExtractor);
    }

    HttpClientSpi<?> createHttpClient() {
        return httpClientBuilder.buildHttpClient(new Configuration(this.url, this.user, this.password, this.httpProxy, new ConnectionConfiguration(this.connectionTimeout, this.socketTimeout, this.tcpNoDelay, this.socketBufferSize), new TlsConfiguration(this.protocolVersion, this.keystore, this.keystorePassword, this.keyPassword, this.truststore, this.truststorePassword), new PoolConfiguration(this.pooledConnections, this.maxTotalConnections, this.maxConnectionPoolTimeout), this.contentCharset, this.expectContinue, this.defaultHttpHeaders, this.customizer, this.clientBuilderClass));
    }

    static Proxy parseProxySettings(String spec) {
        try {
            if (spec == null || spec.isEmpty()) {
                return null;
            }
            return new Proxy(spec);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static class Proxy {
        private final String host;
        private final int port;
        private String user;
        private String pass;

        public Proxy(String host, int port) {
            this(host, port, null, null);
        }

        public Proxy(String host, int port, String user, String pass) {
            this.host = host;
            this.port = port;
            this.user = user;
            this.pass = pass;
        }

        public Proxy(String env) throws URISyntaxException {
            String colon = ":";
            URI uri = new URI(env);
            this.host = uri.getHost();
            this.port = uri.getPort();
            if (this.host == null || this.host.isEmpty() || this.port < 0 || this.port > 65535) {
                throw new URISyntaxException(env, "Invalid host '" + this.host + "' or port " + this.port);
            }
            String userInfo = uri.getUserInfo();
            if (userInfo != null && !userInfo.isEmpty()) {
                if (userInfo.contains(colon)) {
                    this.user = userInfo.substring(0, userInfo.indexOf(colon));
                    this.pass = userInfo.substring(userInfo.indexOf(colon) + 1);
                } else {
                    this.user = userInfo;
                }
            }
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUser() {
            return this.user;
        }

        public String getPass() {
            return this.pass;
        }
    }

    public record Configuration(URI url, String user, String password, Proxy proxy, ConnectionConfiguration connectionConfig, TlsConfiguration tlsConfig, PoolConfiguration poolConfig, Charset contentCharset, boolean expectContinue, Collection<HttpHeader> defaultHttpHeaders, Consumer<?> customizer, Class<?> clientBuilderClass) {
        public static Configuration withUrl(URI url) {
            return new Configuration(url, null, null, null, new ConnectionConfiguration(5000, 5000, false, 8192), null, new PoolConfiguration(true, 20, 500), StandardCharsets.UTF_8, false, Collections.emptySet(), null, null);
        }
    }

    public record ConnectionConfiguration(int connectionTimeout, int socketTimeout, boolean tcpNoDelay, int socketBufferSize) {
    }

    public record TlsConfiguration(String protocolVersion, Path keystore, String keystorePassword, String keyPassword, Path truststore, String truststorePassword) {
    }

    public record PoolConfiguration(boolean usePool, int maxConnections, int connectionPoolTimeout) {
    }
}

