/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jolokia.client.JolokiaClientBuilder;
import org.jolokia.client.JolokiaQueryParameter;
import org.jolokia.client.JolokiaTargetConfig;
import org.jolokia.client.exception.JolokiaBulkRemoteException;
import org.jolokia.client.exception.JolokiaConnectException;
import org.jolokia.client.exception.JolokiaException;
import org.jolokia.client.exception.JolokiaRemoteException;
import org.jolokia.client.request.HttpMethod;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.client.response.JolokiaResponse;
import org.jolokia.client.response.JolokiaResponseExtractor;
import org.jolokia.client.response.ValidatingResponseExtractor;
import org.jolokia.client.spi.HttpClientSpi;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.json.JSONStructure;

public class JolokiaClient
implements Closeable {
    private final HttpClientSpi<?> httpClient;
    private final URI jolokiaAgentUrl;
    private final JolokiaTargetConfig targetConfig;
    private final JolokiaResponseExtractor responseExtractor;

    public JolokiaClient(URI pJolokiaAgentUrl) {
        this(pJolokiaAgentUrl, null);
    }

    public JolokiaClient(URI pJolokiaAgentUrl, HttpClientSpi<?> pHttpClient) {
        this(pJolokiaAgentUrl, pHttpClient, null);
    }

    public JolokiaClient(URI pJolokiaAgentUrl, HttpClientSpi<?> pHttpClient, JolokiaTargetConfig pTargetConfig) {
        this(pJolokiaAgentUrl, pHttpClient, pTargetConfig, ValidatingResponseExtractor.DEFAULT);
    }

    public JolokiaClient(URI pJolokiaAgentUrl, HttpClientSpi<?> pHttpClient, JolokiaTargetConfig pTargetConfig, JolokiaResponseExtractor pExtractor) {
        this.jolokiaAgentUrl = pJolokiaAgentUrl;
        this.targetConfig = pTargetConfig;
        this.responseExtractor = pExtractor;
        if (pHttpClient != null) {
            this.httpClient = pHttpClient;
        } else {
            JolokiaClientBuilder builder = new JolokiaClientBuilder().url(pJolokiaAgentUrl);
            if (this.targetConfig != null) {
                builder.target(this.targetConfig.url()).targetUser(this.targetConfig.user()).targetPassword(this.targetConfig.password());
            }
            this.httpClient = builder.createHttpClient();
        }
    }

    public URI getUri() {
        return this.jolokiaAgentUrl;
    }

    public <T> T getHttpClient(Class<T> clientClass) {
        return (T)this.httpClient.getClient(clientClass);
    }

    public <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> RESP execute(REQ pRequest) throws JolokiaException {
        return this.execute(pRequest, null, null);
    }

    public <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> RESP execute(REQ pRequest, Map<JolokiaQueryParameter, String> pProcessingOptions) throws JolokiaException {
        return this.execute(pRequest, null, pProcessingOptions);
    }

    public <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> RESP execute(REQ pRequest, HttpMethod pMethod) throws JolokiaException {
        return this.execute(pRequest, pMethod, null);
    }

    public <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> RESP execute(REQ pRequest, HttpMethod pMethod, Map<JolokiaQueryParameter, String> pProcessingOptions) throws JolokiaException {
        return this.execute(pRequest, pMethod, pProcessingOptions, this.responseExtractor);
    }

    public <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> RESP execute(REQ pRequest, HttpMethod pMethod, Map<JolokiaQueryParameter, String> pProcessingOptions, JolokiaResponseExtractor pResponseExtractor) throws JolokiaException {
        try {
            JSONStructure jsonResponse = this.httpClient.execute(pRequest, pMethod, pProcessingOptions, this.targetConfig);
            if (!(jsonResponse instanceof JSONObject)) {
                String msg = jsonResponse == null ? "an empty response" : "a " + jsonResponse.getClass().getName();
                throw new JolokiaException("Invalid JSON response for a single request (expected a Map but got " + msg + ")");
            }
            return this.extractResponse((JSONObject)jsonResponse, pRequest, pProcessingOptions, pResponseExtractor);
        }
        catch (IOException e) {
            throw this.mapException(e);
        }
    }

    public <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> List<RESP> execute(List<REQ> pRequests) throws JolokiaException {
        return this.execute(pRequests, null);
    }

    public <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> List<RESP> execute(List<REQ> pRequests, Map<JolokiaQueryParameter, String> pProcessingOptions) throws JolokiaException {
        return this.execute(pRequests, pProcessingOptions, this.responseExtractor);
    }

    @SafeVarargs
    public final <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> List<RESP> execute(REQ ... pRequests) throws JolokiaException {
        return this.execute(Arrays.asList(pRequests));
    }

    public <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> List<RESP> execute(List<REQ> pRequests, Map<JolokiaQueryParameter, String> pProcessingOptions, JolokiaResponseExtractor pResponseExtractor) throws JolokiaException {
        try {
            JSONStructure jsonResponse = this.httpClient.execute(pRequests, pProcessingOptions, this.targetConfig);
            if (!(jsonResponse instanceof JSONArray)) {
                JSONObject errorObject;
                if (jsonResponse instanceof JSONObject && (!(errorObject = (JSONObject)jsonResponse).containsKey((Object)"status") || ((Number)errorObject.get((Object)"status")).intValue() != 200)) {
                    throw new JolokiaRemoteException(null, errorObject);
                }
                throw new JolokiaException("Invalid JSON response for a bulk request (expected an array but got a " + jsonResponse.getClass().getName() + ")");
            }
            return this.extractResponses((JSONArray)jsonResponse, pRequests, pProcessingOptions, pResponseExtractor);
        }
        catch (IOException e) {
            throw this.mapException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> RESP extractResponse(JSONObject jsonResponse, REQ pRequest, Map<JolokiaQueryParameter, String> pProcessingOptions, JolokiaResponseExtractor pResponseExtractor) throws JolokiaException {
        boolean excludeRequest = pProcessingOptions != null && "false".equals(pProcessingOptions.get((Object)JolokiaQueryParameter.INCLUDE_REQUEST));
        return pResponseExtractor.extract(pRequest, jsonResponse, !excludeRequest);
    }

    private <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> List<RESP> extractResponses(JSONArray pJsonResponse, List<REQ> pRequests, Map<JolokiaQueryParameter, String> pProcessingOptions, JolokiaResponseExtractor pResponseExtractor) throws JolokiaException {
        ArrayList ret = new ArrayList(pJsonResponse.size());
        JolokiaRemoteException[] remoteExceptions = new JolokiaRemoteException[pJsonResponse.size()];
        boolean excludeRequest = pProcessingOptions != null && "false".equals(pProcessingOptions.get((Object)JolokiaQueryParameter.INCLUDE_REQUEST));
        boolean exceptionFound = false;
        for (int i = 0; i < pRequests.size(); ++i) {
            JolokiaRequest request = (JolokiaRequest)pRequests.get(i);
            Object jsonResp = pJsonResponse.get(i);
            if (!(jsonResp instanceof JSONObject)) {
                throw new JolokiaException("Response for request Nr " + i + " is invalid (expected a Map but got " + jsonResp.getClass().getName() + ")");
            }
            try {
                ret.add(i, pResponseExtractor.extract(request, (JSONObject)jsonResp, !excludeRequest));
                continue;
            }
            catch (JolokiaRemoteException exp) {
                remoteExceptions[i] = exp;
                exceptionFound = true;
                ret.add(i, null);
            }
        }
        if (exceptionFound) {
            ArrayList<Object> responsesAndErrors = new ArrayList<Object>();
            for (int i = 0; i < pRequests.size(); ++i) {
                JolokiaRemoteException exp = remoteExceptions[i];
                if (exp != null) {
                    responsesAndErrors.add(exp);
                    continue;
                }
                responsesAndErrors.add(ret.get(i));
            }
            throw new JolokiaBulkRemoteException(responsesAndErrors);
        }
        return ret;
    }

    private JolokiaException mapException(IOException ex) {
        if (ex instanceof ConnectException) {
            ConnectException cex = (ConnectException)ex;
            String msg = "Cannot connect to " + String.valueOf(this.jolokiaAgentUrl) + (String)(ex.getMessage() != null ? ": " + ex.getMessage() : "");
            return new JolokiaConnectException(msg, cex);
        }
        return new JolokiaException("IO-Error during connection to " + String.valueOf(this.jolokiaAgentUrl) + ": " + ex.getMessage(), ex);
    }
}

