/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jolokia.client.EscapeUtil;
import org.jolokia.client.HttpUtil;
import org.jolokia.client.JolokiaClientBuilder;
import org.jolokia.client.JolokiaQueryParameter;
import org.jolokia.client.JolokiaTargetConfig;
import org.jolokia.client.exception.JolokiaConnectException;
import org.jolokia.client.exception.JolokiaException;
import org.jolokia.client.exception.JolokiaRemoteException;
import org.jolokia.client.exception.JolokiaTimeoutException;
import org.jolokia.client.request.HttpMethod;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.client.response.JolokiaResponse;
import org.jolokia.client.spi.HttpClientSpi;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.json.JSONStructure;
import org.jolokia.json.parser.ParseException;

public class Http4Client
implements HttpClientSpi<HttpClient> {
    private final HttpClient client;
    private final JolokiaClientBuilder.Configuration config;
    private final URI jolokiaAgentUrl;

    public Http4Client(HttpClient client, JolokiaClientBuilder.Configuration configuration) {
        this.client = client;
        this.config = configuration;
        this.jolokiaAgentUrl = this.config.url();
    }

    public HttpClient getClient(Class<HttpClient> clientClass) {
        if (clientClass.isAssignableFrom(this.client.getClass())) {
            return clientClass.cast(this.client);
        }
        return null;
    }

    public <REQ extends JolokiaRequest, RES extends JolokiaResponse<REQ>> JSONStructure execute(REQ pRequest, HttpMethod method, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig targetConfig) throws IOException, JolokiaException {
        HttpUriRequest httpRequest = this.prepareRequest(pRequest, method, parameters, targetConfig);
        return this.execute(httpRequest, pRequest, pRequest.getType().getValue());
    }

    public <REQ extends JolokiaRequest, RES extends JolokiaResponse<REQ>> JSONStructure execute(List<REQ> pRequests, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig targetConfig) throws IOException, JolokiaException {
        HttpUriRequest httpRequest = this.prepareRequests(pRequests, parameters, targetConfig);
        return this.execute(httpRequest, null, "bulk");
    }

    public void close() throws IOException {
        HttpClient httpClient = this.client;
        if (httpClient instanceof CloseableHttpClient) {
            CloseableHttpClient closable = (CloseableHttpClient)httpClient;
            closable.close();
        }
    }

    private <REQ extends JolokiaRequest> HttpUriRequest prepareRequest(REQ pRequest, HttpMethod method, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig pTargetConfig) {
        JolokiaTargetConfig targetConfig = HttpUtil.determineTargetConfig(pRequest, (JolokiaTargetConfig)pTargetConfig);
        HttpMethod selectedMethod = HttpUtil.determineHttpMethod(pRequest, (HttpMethod)method, (JolokiaTargetConfig)targetConfig);
        String queryParams = HttpUtil.toQueryString(parameters);
        Charset charset = this.config.contentCharset() == null ? StandardCharsets.UTF_8 : this.config.contentCharset();
        HttpPost request = null;
        if (selectedMethod.equals((Object)HttpMethod.GET)) {
            if (targetConfig != null) {
                throw new IllegalArgumentException("Proxy requests should be sent using POST method");
            }
            List parts = pRequest.getRequestParts();
            if (parts != null) {
                String base = HttpUtil.prepareBaseUrl((URI)this.jolokiaAgentUrl);
                StringBuilder requestPath = new StringBuilder(base);
                requestPath.append(pRequest.getType().getValue());
                for (String p : parts) {
                    requestPath.append("/");
                    requestPath.append(EscapeUtil.escape((String)p));
                }
                URI uri = HttpUtil.prepareFullUrl((URI)this.jolokiaAgentUrl, (String)requestPath.toString(), (String)queryParams);
                request = new HttpGet(uri);
            }
        }
        if (request == null) {
            HttpPost postRequest = new HttpPost(HttpUtil.prepareFullUrl((URI)this.jolokiaAgentUrl, (String)this.jolokiaAgentUrl.getPath(), (String)queryParams));
            JSONObject requestContent = HttpUtil.getJsonRequestContent(pRequest, (JolokiaTargetConfig)targetConfig);
            postRequest.setEntity((HttpEntity)new StringEntity(requestContent.toJSONString(), StandardCharsets.UTF_8));
            postRequest.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            request = postRequest;
        }
        return request;
    }

    private <REQ extends JolokiaRequest> HttpUriRequest prepareRequests(List<REQ> pRequests, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig pTargetConfig) {
        String queryParams = HttpUtil.toQueryString(parameters);
        Charset charset = this.config.contentCharset() == null ? StandardCharsets.UTF_8 : this.config.contentCharset();
        JSONArray bulkRequest = new JSONArray(pRequests.size());
        for (JolokiaRequest request : pRequests) {
            JSONObject requestContent = HttpUtil.getJsonRequestContent((JolokiaRequest)request, (JolokiaTargetConfig)HttpUtil.determineTargetConfig((JolokiaRequest)request, (JolokiaTargetConfig)pTargetConfig));
            bulkRequest.add((Object)requestContent);
        }
        HttpPost request = new HttpPost(HttpUtil.prepareFullUrl((URI)this.jolokiaAgentUrl, (String)this.jolokiaAgentUrl.getPath(), (String)queryParams));
        request.setEntity((HttpEntity)new StringEntity(bulkRequest.toJSONString(), StandardCharsets.UTF_8));
        request.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONStructure execute(HttpUriRequest httpRequest, JolokiaRequest jolokiaRequest, String requestType) throws JolokiaException {
        try {
            HttpResponse response = this.client.execute(httpRequest);
            StatusLine statusLine = response.getStatusLine();
            int errorCode = statusLine.getStatusCode();
            if (errorCode != 200) {
                throw new JolokiaRemoteException(jolokiaRequest, "HTTP error " + errorCode + " sending " + requestType + " Jolokia request", null, errorCode, null, null);
            }
            HttpEntity entity = response.getEntity();
            try {
                Header contentEncoding = entity.getContentEncoding();
                Charset encoding = contentEncoding == null ? (this.config.contentCharset() == null ? StandardCharsets.ISO_8859_1 : this.config.contentCharset()) : Charset.forName(contentEncoding.getValue());
                JSONStructure jSONStructure = HttpUtil.parseJsonResponse((InputStream)entity.getContent(), (Charset)encoding);
                return jSONStructure;
            }
            catch (ParseException e) {
                String errorType = ((Object)((Object)e)).getClass().getName();
                String message = "Error parsing " + requestType + " response: " + e.getMessage();
                throw new JolokiaRemoteException(jolokiaRequest, message, errorType, errorCode, null, null);
            }
            finally {
                if (entity != null) {
                    EntityUtils.consume((HttpEntity)entity);
                }
            }
        }
        catch (ConnectException e) {
            String msg = "Cannot connect to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
            throw new JolokiaConnectException(msg, e);
        }
        catch (ConnectTimeoutException e) {
            String msg = "Connection timeout when sending " + requestType + " request to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
            throw new JolokiaTimeoutException(msg, (IOException)((Object)e));
        }
        catch (IOException e) {
            String msg = "IO exception when processing " + requestType + " request to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
            throw new JolokiaTimeoutException(msg, e);
        }
    }
}

