/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.jetty;

import org.joinfaces.jetty.JettyProperties;
import org.joinfaces.jetty.JsfJettyServerCustomizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={JettyProperties.class})
@ConditionalOnClass(name={"org.eclipse.jetty.server.Server"})
public class JettySpringBootAutoConfiguration
implements EmbeddedServletContainerCustomizer {
    @Autowired
    private JettyProperties jettyProperties;

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (container instanceof JettyEmbeddedServletContainerFactory) {
            ((JettyEmbeddedServletContainerFactory)container).addServerCustomizers(new JettyServerCustomizer[]{new JsfJettyServerCustomizer(this.jettyProperties)});
        }
    }
}

