/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.integration;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.joinfaces.integration.AnnotationToScopeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;

public class CustomScopeAnnotationConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomScopeAnnotationConfigurer.class);
    private int order = Integer.MAX_VALUE;
    private List<AnnotationToScopeMapping> annotationToScopeMappings;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory clbf) throws BeansException {
        for (String beanName : clbf.getBeanDefinitionNames()) {
            BeanDefinition definition = clbf.getBeanDefinition(beanName);
            this.registerJsfCdiToSpring(definition);
        }
    }

    private void registerJsfCdiToSpring(BeanDefinition definition) {
        if (definition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annDef = (AnnotatedBeanDefinition)definition;
            String scopeName = null;
            scopeName = annDef.getFactoryMethodMetadata() != null ? this.deduceScopeName(annDef.getFactoryMethodMetadata()) : this.deduceScopeName(annDef.getMetadata());
            if (scopeName != null) {
                definition.setScope(scopeName);
                log.debug("{} - Scope({})", (Object)definition.getBeanClassName(), (Object)definition.getScope().toUpperCase());
            }
        }
    }

    protected String deduceScopeName(MethodMetadata factoryMethodMetadata) {
        if (this.getAnnotationToScopeMappings() == null) {
            return null;
        }
        for (AnnotationToScopeMapping annotationToScopeMapping : this.getAnnotationToScopeMappings()) {
            if (!factoryMethodMetadata.isAnnotated(annotationToScopeMapping.getAnnotation().getName())) continue;
            return annotationToScopeMapping.getScope();
        }
        return null;
    }

    protected String deduceScopeName(AnnotationMetadata classMetadata) {
        if (classMetadata == null || this.getAnnotationToScopeMappings() == null) {
            return null;
        }
        for (AnnotationToScopeMapping annotationToScopeMapping : this.getAnnotationToScopeMappings()) {
            if (!classMetadata.hasAnnotation(annotationToScopeMapping.getAnnotation().getName())) continue;
            return annotationToScopeMapping.getScope();
        }
        return null;
    }

    public void addMapping(Class<? extends Annotation> annotation, String scopeName) {
        this.addMapping(new AnnotationToScopeMapping(annotation, scopeName));
    }

    public void addMapping(AnnotationToScopeMapping annotationToScopeMapping) {
        if (this.annotationToScopeMappings == null) {
            this.annotationToScopeMappings = new LinkedList<AnnotationToScopeMapping>();
        }
        this.annotationToScopeMappings.add(annotationToScopeMapping);
    }

    @Generated
    public List<AnnotationToScopeMapping> getAnnotationToScopeMappings() {
        return this.annotationToScopeMappings;
    }

    @Generated
    public void setAnnotationToScopeMappings(List<AnnotationToScopeMapping> annotationToScopeMappings) {
        this.annotationToScopeMappings = annotationToScopeMappings;
    }

    @Generated
    public CustomScopeAnnotationConfigurer() {
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

