/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;
import javax.servlet.annotation.HandlesTypes;
import org.joinfaces.JsfClassFactoryConfiguration;
import org.joinfaces.TypesHandled;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class JsfClassFactory {
    private JsfClassFactoryConfiguration jsfAnnotatedClassFactoryConfiguration;
    private Collection<URL> urls;
    private Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClassMap;
    private Map<Class<?>, Set<Class<?>>> otherClassMap;

    public JsfClassFactory(JsfClassFactoryConfiguration jsfAnnotatedClassFactoryConfiguration) {
        this.jsfAnnotatedClassFactoryConfiguration = jsfAnnotatedClassFactoryConfiguration;
    }

    private Set<Class<? extends Annotation>> annotationsToExclude() {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        if (this.jsfAnnotatedClassFactoryConfiguration.isExcludeScopedAnnotations()) {
            result.add(ViewScoped.class);
            result.add(SessionScoped.class);
            result.add(RequestScoped.class);
            result.add(NoneScoped.class);
        }
        return result;
    }

    private TypesHandled handlesTypes() {
        TypesHandled result = new TypesHandled();
        HandlesTypes ht = null;
        if (this.jsfAnnotatedClassFactoryConfiguration.getServletContainerInitializer() != null) {
            ht = this.jsfAnnotatedClassFactoryConfiguration.getServletContainerInitializer().getClass().getAnnotation(HandlesTypes.class);
        }
        if (ht != null) {
            Set<Class<? extends Annotation>> annotationsToExclude = this.annotationsToExclude();
            for (Class type : ht.value()) {
                if (type.isAnnotation()) {
                    Class annotation = type;
                    if (annotationsToExclude.contains(annotation)) continue;
                    result.getAnnotationTypes().add(annotation);
                    continue;
                }
                result.getOtherTypes().add(type);
            }
        }
        return result;
    }

    private void add(Collection<URL> urls, Collection<String> strings, Collection<URL> newURLs) {
        for (URL url : newURLs) {
            this.add(urls, strings, url);
        }
    }

    private void add(Collection<URL> urls, Collection<String> strings, URL url) {
        String string = url.toString();
        if (!strings.contains(string)) {
            urls.add(url);
            strings.add(string);
        }
    }

    private boolean isClassesFolder(String file) {
        return file.endsWith("/classes/") || file.endsWith("/classes!/") || new File(file).isDirectory();
    }

    public Collection<URL> getURLs() {
        if (this.urls == null) {
            ArrayList<URL> result = new ArrayList<URL>();
            HashSet<String> strings = new HashSet<String>();
            this.add(result, strings, ClasspathHelper.forResource((String)"META-INF/faces-config.xml", (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()}));
            String anotherFacesConfig = this.jsfAnnotatedClassFactoryConfiguration.getAnotherFacesConfig();
            if (anotherFacesConfig != null) {
                this.add(result, strings, ClasspathHelper.forResource((String)anotherFacesConfig, (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()}));
            }
            for (URL url : ClasspathHelper.forManifest()) {
                String file = url.getFile();
                if (!this.isClassesFolder(file)) continue;
                this.add(result, strings, url);
            }
            this.urls = result;
        }
        return this.urls;
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClassMap() {
        if (this.annotatedClassMap == null) {
            this.computeClasses();
        }
        return this.annotatedClassMap;
    }

    public Map<Class<?>, Set<Class<?>>> getOtherClassMap() {
        if (this.otherClassMap == null) {
            this.computeClasses();
        }
        return this.otherClassMap;
    }

    private void computeClasses() {
        this.annotatedClassMap = new HashMap();
        this.otherClassMap = new HashMap();
        TypesHandled handlesTypes = this.handlesTypes();
        if (!handlesTypes.isEmpty()) {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setExpandSuperTypes(false).setUrls(this.getURLs()));
            for (Class<? extends Annotation> clazz : handlesTypes.getAnnotationTypes()) {
                this.annotatedClassMap.put(clazz, reflections.getTypesAnnotatedWith(clazz));
            }
            for (Class<? extends Annotation> clazz : handlesTypes.getOtherTypes()) {
                this.otherClassMap.put(clazz, reflections.getSubTypesOf(clazz));
            }
        }
    }

    public Set<Class<?>> getAllClasses() {
        HashSet result = new HashSet();
        result.addAll(this.getAnnotatedClasses());
        result.addAll(this.getOtherClasses());
        return result;
    }

    public Set<Class<?>> getAnnotatedClasses() {
        return this.collectValues(this.getAnnotatedClassMap().values());
    }

    public Set<Class<?>> getOtherClasses() {
        return this.collectValues(this.getOtherClassMap().values());
    }

    private Set<Class<?>> collectValues(Collection<Set<Class<?>>> sets) {
        HashSet classes = new HashSet();
        for (Set<Class<?>> values : sets) {
            classes.addAll(values);
        }
        return classes;
    }
}

