/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoadException;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.gltf.GltfLoader;
import com.jme3.scene.plugins.gltf.GltfModelKey;
import com.jme3.scene.plugins.gltf.MaterialAdapter;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import com.jme3.util.LittleEndien;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GltfUtils {
    private static final Logger logger = Logger.getLogger(GltfUtils.class.getName());
    private static float epsilon = 1.0E-4f;

    private GltfUtils() {
    }

    public static Mesh.Mode getMeshMode(Integer mode) {
        if (mode == null) {
            return Mesh.Mode.Triangles;
        }
        switch (mode) {
            case 0: {
                return Mesh.Mode.Points;
            }
            case 1: {
                return Mesh.Mode.Lines;
            }
            case 2: {
                return Mesh.Mode.LineLoop;
            }
            case 3: {
                return Mesh.Mode.LineStrip;
            }
            case 4: {
                return Mesh.Mode.Triangles;
            }
            case 5: {
                return Mesh.Mode.TriangleStrip;
            }
            case 6: {
                return Mesh.Mode.TriangleFan;
            }
        }
        return Mesh.Mode.Triangles;
    }

    public static VertexBuffer.Format getVertexBufferFormat(int componentType) {
        switch (componentType) {
            case 5120: {
                return VertexBuffer.Format.Byte;
            }
            case 5121: {
                return VertexBuffer.Format.UnsignedByte;
            }
            case 5122: {
                return VertexBuffer.Format.Short;
            }
            case 5123: {
                return VertexBuffer.Format.UnsignedShort;
            }
            case 5125: {
                return VertexBuffer.Format.UnsignedInt;
            }
            case 5126: {
                return VertexBuffer.Format.Float;
            }
        }
        throw new AssetLoadException("Illegal component type: " + componentType);
    }

    public static int getNumberOfComponents(String type) {
        switch (type) {
            case "SCALAR": {
                return 1;
            }
            case "VEC2": {
                return 2;
            }
            case "VEC3": {
                return 3;
            }
            case "VEC4": {
                return 4;
            }
            case "MAT2": {
                return 4;
            }
            case "MAT3": {
                return 9;
            }
            case "MAT4": {
                return 16;
            }
        }
        throw new AssetLoadException("Illegal type: " + type);
    }

    public static VertexBuffer.Type getVertexBufferType(String attribute) {
        switch (attribute) {
            case "POSITION": {
                return VertexBuffer.Type.Position;
            }
            case "NORMAL": {
                return VertexBuffer.Type.Normal;
            }
            case "TANGENT": {
                return VertexBuffer.Type.Tangent;
            }
            case "TEXCOORD_0": {
                return VertexBuffer.Type.TexCoord;
            }
            case "TEXCOORD_1": {
                return VertexBuffer.Type.TexCoord2;
            }
            case "TEXCOORD_2": {
                return VertexBuffer.Type.TexCoord3;
            }
            case "TEXCOORD_3": {
                return VertexBuffer.Type.TexCoord4;
            }
            case "TEXCOORD_4": {
                return VertexBuffer.Type.TexCoord5;
            }
            case "TEXCOORD_5": {
                return VertexBuffer.Type.TexCoord6;
            }
            case "TEXCOORD_6": {
                return VertexBuffer.Type.TexCoord7;
            }
            case "TEXCOORD_7": {
                return VertexBuffer.Type.TexCoord8;
            }
            case "COLOR_0": {
                return VertexBuffer.Type.Color;
            }
            case "JOINTS_0": {
                return VertexBuffer.Type.BoneIndex;
            }
            case "WEIGHTS_0": {
                return VertexBuffer.Type.BoneWeight;
            }
        }
        logger.log(Level.WARNING, "Unsupported Vertex Buffer type " + attribute);
        return null;
    }

    public static int getIndex(String name) {
        String num = name.substring(name.lastIndexOf("_") + 1);
        return Integer.parseInt(num);
    }

    public static Texture.MagFilter getMagFilter(Integer value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case 9728: {
                return Texture.MagFilter.Nearest;
            }
            case 9729: {
                return Texture.MagFilter.Bilinear;
            }
        }
        return null;
    }

    public static Texture.MinFilter getMinFilter(Integer value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case 9728: {
                return Texture.MinFilter.NearestNoMipMaps;
            }
            case 9729: {
                return Texture.MinFilter.BilinearNoMipMaps;
            }
            case 9984: {
                return Texture.MinFilter.NearestNearestMipMap;
            }
            case 9985: {
                return Texture.MinFilter.BilinearNearestMipMap;
            }
            case 9986: {
                return Texture.MinFilter.NearestLinearMipMap;
            }
            case 9987: {
                return Texture.MinFilter.Trilinear;
            }
        }
        return null;
    }

    public static Texture.WrapMode getWrapMode(Integer value) {
        if (value == null) {
            return Texture.WrapMode.Repeat;
        }
        switch (value) {
            case 33071: {
                return Texture.WrapMode.EdgeClamp;
            }
            case 33648: {
                return Texture.WrapMode.MirroredRepeat;
            }
        }
        return Texture.WrapMode.Repeat;
    }

    public static void padBuffer(Object store, int bufferSize) {
        block18: {
            Object[] array;
            block21: {
                block20: {
                    block19: {
                        block17: {
                            if (store instanceof Buffer) {
                                int i;
                                Buffer buffer = (Buffer)store;
                                buffer.clear();
                                if (buffer instanceof IntBuffer) {
                                    IntBuffer ib = (IntBuffer)buffer;
                                    for (i = 0; i < bufferSize; ++i) {
                                        ib.put(0);
                                    }
                                } else if (buffer instanceof FloatBuffer) {
                                    FloatBuffer fb = (FloatBuffer)buffer;
                                    for (i = 0; i < bufferSize; ++i) {
                                        fb.put(0.0f);
                                    }
                                } else if (buffer instanceof ShortBuffer) {
                                    ShortBuffer sb = (ShortBuffer)buffer;
                                    for (i = 0; i < bufferSize; ++i) {
                                        sb.put((short)0);
                                    }
                                } else if (buffer instanceof ByteBuffer) {
                                    ByteBuffer bb = (ByteBuffer)buffer;
                                    for (i = 0; i < bufferSize; ++i) {
                                        bb.put((byte)0);
                                    }
                                }
                                buffer.rewind();
                            }
                            if (!(store instanceof short[])) break block17;
                            array = (short[])store;
                            for (int i = 0; i < array.length; ++i) {
                                array[i] = 0;
                            }
                            break block18;
                        }
                        if (!(store instanceof float[])) break block19;
                        array = (float[])store;
                        for (int i = 0; i < array.length; ++i) {
                            array[i] = (short)0.0f;
                        }
                        break block18;
                    }
                    if (!(store instanceof Vector3f[])) break block20;
                    array = (Vector3f[])store;
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = (short)new Vector3f();
                    }
                    break block18;
                }
                if (!(store instanceof Quaternion[])) break block21;
                array = (Quaternion[])store;
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (short)new Quaternion();
                }
                break block18;
            }
            if (!(store instanceof Matrix4f[])) break block18;
            array = (Matrix4f[])store;
            for (int i = 0; i < array.length; ++i) {
                array[i] = (short)new Matrix4f();
            }
        }
    }

    public static void populateBuffer(Object store, byte[] source, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        if (store instanceof Buffer) {
            Buffer buffer = (Buffer)store;
            buffer.clear();
            if (buffer instanceof ByteBuffer) {
                GltfUtils.populateByteBuffer((ByteBuffer)buffer, source, count, byteOffset, byteStride, numComponents, format);
                return;
            }
            LittleEndien stream = GltfUtils.getStream(source);
            if (buffer instanceof ShortBuffer) {
                GltfUtils.populateShortBuffer((ShortBuffer)buffer, stream, count, byteOffset, byteStride, numComponents, format);
            } else if (buffer instanceof IntBuffer) {
                GltfUtils.populateIntBuffer((IntBuffer)buffer, stream, count, byteOffset, byteStride, numComponents, format);
            } else if (buffer instanceof FloatBuffer) {
                GltfUtils.populateFloatBuffer((FloatBuffer)buffer, stream, count, byteOffset, byteStride, numComponents, format);
            }
            buffer.rewind();
            return;
        }
        LittleEndien stream = GltfUtils.getStream(source);
        if (store instanceof byte[]) {
            GltfUtils.populateByteArray((byte[])store, stream, count, byteOffset, byteStride, numComponents, format);
        } else if (store instanceof short[]) {
            GltfUtils.populateShortArray((short[])store, stream, count, byteOffset, byteStride, numComponents, format);
        } else if (store instanceof float[]) {
            GltfUtils.populateFloatArray((float[])store, stream, count, byteOffset, byteStride, numComponents, format);
        } else if (store instanceof Vector3f[]) {
            GltfUtils.populateVector3fArray((Vector3f[])store, stream, count, byteOffset, byteStride, numComponents, format);
        } else if (store instanceof Quaternion[]) {
            GltfUtils.populateQuaternionArray((Quaternion[])store, stream, count, byteOffset, byteStride, numComponents, format);
        } else if (store instanceof Matrix4f[]) {
            GltfUtils.populateMatrix4fArray((Matrix4f[])store, stream, count, byteOffset, byteStride, numComponents, format);
        }
    }

    private static void populateByteBuffer(ByteBuffer buffer, byte[] source, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        for (int index = byteOffset; index < end; index += stride) {
            for (int i = 0; i < numComponents; ++i) {
                buffer.put(source[index + i]);
            }
        }
    }

    private static void populateShortBuffer(ShortBuffer buffer, LittleEndien stream, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        stream.skipBytes(byteOffset);
        for (int index = byteOffset; index < end; index += stride) {
            for (int i = 0; i < numComponents; ++i) {
                buffer.put(stream.readShort());
            }
            if (dataLength >= stride) continue;
            stream.skipBytes(stride - dataLength);
        }
    }

    private static void populateIntBuffer(IntBuffer buffer, LittleEndien stream, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        stream.skipBytes(byteOffset);
        for (int index = byteOffset; index < end; index += stride) {
            for (int i = 0; i < numComponents; ++i) {
                buffer.put(stream.readInt());
            }
            if (dataLength >= stride) continue;
            stream.skipBytes(stride - dataLength);
        }
    }

    private static void populateFloatBuffer(FloatBuffer buffer, LittleEndien stream, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        stream.skipBytes(byteOffset);
        for (int index = byteOffset; index < end; index += stride) {
            for (int i = 0; i < numComponents; ++i) {
                buffer.put(GltfUtils.readAsFloat(stream, format));
            }
            if (dataLength >= stride) continue;
            stream.skipBytes(stride - dataLength);
        }
    }

    public static float readAsFloat(LittleEndien stream, VertexBuffer.Format format) throws IOException {
        switch (format) {
            case Byte: {
                byte c = stream.readByte();
                return Math.max((float)c / 127.0f, -1.0f);
            }
            case UnsignedByte: {
                int c = stream.readUnsignedByte();
                return (float)c / 255.0f;
            }
            case Short: {
                short c = stream.readShort();
                return Math.max((float)c / 32767.0f, -1.0f);
            }
            case UnsignedShort: {
                int c = stream.readUnsignedShort();
                return (float)c / 65535.0f;
            }
        }
        return stream.readFloat();
    }

    private static void populateByteArray(byte[] array, LittleEndien stream, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        stream.skipBytes(byteOffset);
        int arrayIndex = 0;
        for (int index = byteOffset; index < end; index += stride) {
            for (int i = 0; i < numComponents; ++i) {
                array[arrayIndex] = stream.readByte();
                ++arrayIndex;
            }
            if (dataLength >= stride) continue;
            stream.skipBytes(stride - dataLength);
        }
    }

    private static void populateShortArray(short[] array, LittleEndien stream, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        stream.skipBytes(byteOffset);
        int arrayIndex = 0;
        for (int index = byteOffset; index < end; index += stride) {
            for (int i = 0; i < numComponents; ++i) {
                array[arrayIndex] = componentSize == 2 ? stream.readShort() : (short)stream.readByte();
                ++arrayIndex;
            }
            if (dataLength >= stride) continue;
            stream.skipBytes(stride - dataLength);
        }
    }

    public static byte[] toByteArray(short[] shortArray) {
        byte[] bytes = new byte[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            bytes[i] = (byte)shortArray[i];
        }
        return bytes;
    }

    public static void handleSkinningBuffers(Mesh mesh, IntMap<GltfLoader.SkinBuffers> skinBuffers) {
        if (skinBuffers.size() > 0) {
            int length = ((GltfLoader.SkinBuffers)skinBuffers.get((int)0)).joints.length;
            short[] jointsArray = new short[length];
            float[] weightsArray = new float[length];
            ArrayList<GltfLoader.WeightData> weightData = new ArrayList<GltfLoader.WeightData>();
            int componentSize = 1;
            for (int i = 0; i < weightsArray.length; i += 4) {
                weightData.clear();
                for (int j = 0; j < skinBuffers.size(); ++j) {
                    GltfLoader.SkinBuffers buffs = (GltfLoader.SkinBuffers)skinBuffers.get(j);
                    for (int k = 0; k < 4; ++k) {
                        weightData.add(new GltfLoader.WeightData(buffs.weights[i + k], buffs.joints[i + k], buffs.componentSize));
                    }
                }
                Collections.sort(weightData, new Comparator<GltfLoader.WeightData>(){

                    @Override
                    public int compare(GltfLoader.WeightData o1, GltfLoader.WeightData o2) {
                        if (o1.value > o2.value) {
                            return -1;
                        }
                        if (o1.value < o2.value) {
                            return 1;
                        }
                        return 0;
                    }
                });
                float sum = 0.0f;
                for (int j = 0; j < 4; ++j) {
                    GltfLoader.WeightData data = (GltfLoader.WeightData)weightData.get(j);
                    jointsArray[i + j] = data.index;
                    weightsArray[i + j] = data.value;
                    sum += data.value;
                    if (data.value > 0.0f && j + 1 > mesh.getMaxNumWeights()) {
                        mesh.setMaxNumWeights(j + 1);
                    }
                    if (data.componentSize <= componentSize) continue;
                    componentSize = data.componentSize;
                }
                if (sum == 1.0f) continue;
                float sumToB = sum == 0.0f ? 0.0f : 1.0f / sum;
                int n = i;
                weightsArray[n] = weightsArray[n] * sumToB;
                int n2 = i + 1;
                weightsArray[n2] = weightsArray[n2] * sumToB;
                int n3 = i + 2;
                weightsArray[n3] = weightsArray[n3] * sumToB;
                int n4 = i + 3;
                weightsArray[n4] = weightsArray[n4] * sumToB;
            }
            GltfUtils.setSkinBuffers(mesh, jointsArray, weightsArray, componentSize);
        }
    }

    public static void setSkinBuffers(Mesh mesh, short[] jointsArray, float[] weightsArray, int componentSize) {
        if (componentSize == 1) {
            mesh.setBuffer(VertexBuffer.Type.BoneIndex, 4, BufferUtils.createByteBuffer((byte[])GltfUtils.toByteArray(jointsArray)));
        } else {
            mesh.setBuffer(VertexBuffer.Type.BoneIndex, 4, BufferUtils.createShortBuffer((short[])jointsArray));
        }
        mesh.setBuffer(VertexBuffer.Type.BoneWeight, 4, BufferUtils.createFloatBuffer((float[])weightsArray));
        mesh.getBuffer(VertexBuffer.Type.BoneIndex).setUsage(VertexBuffer.Usage.CpuOnly);
        mesh.getBuffer(VertexBuffer.Type.BoneWeight).setUsage(VertexBuffer.Usage.CpuOnly);
    }

    private static void populateFloatArray(float[] array, LittleEndien stream, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        stream.skipBytes(byteOffset);
        int arrayIndex = 0;
        for (int index = byteOffset; index < end; index += stride) {
            for (int i = 0; i < numComponents; ++i) {
                array[arrayIndex] = GltfUtils.readAsFloat(stream, format);
                ++arrayIndex;
            }
            if (dataLength >= stride) continue;
            stream.skipBytes(stride - dataLength);
        }
    }

    private static void populateVector3fArray(Vector3f[] array, LittleEndien stream, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        stream.skipBytes(byteOffset);
        int arrayIndex = 0;
        for (int index = byteOffset; index < end; index += stride) {
            array[arrayIndex] = new Vector3f(GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format));
            ++arrayIndex;
            if (dataLength >= stride) continue;
            stream.skipBytes(stride - dataLength);
        }
    }

    private static void populateQuaternionArray(Quaternion[] array, LittleEndien stream, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        stream.skipBytes(byteOffset);
        int arrayIndex = 0;
        for (int index = byteOffset; index < end; index += stride) {
            array[arrayIndex] = new Quaternion(GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format));
            ++arrayIndex;
            if (dataLength >= stride) continue;
            stream.skipBytes(stride - dataLength);
        }
    }

    private static void populateMatrix4fArray(Matrix4f[] array, LittleEndien stream, int count, int byteOffset, int byteStride, int numComponents, VertexBuffer.Format format) throws IOException {
        int componentSize = format.getComponentSize();
        int dataLength = componentSize * numComponents;
        int stride = Math.max(dataLength, byteStride);
        int end = count * stride + byteOffset;
        stream.skipBytes(byteOffset);
        int arrayIndex = 0;
        for (int index = byteOffset; index < end; index += stride) {
            array[arrayIndex] = GltfUtils.toRowMajor(GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format), GltfUtils.readAsFloat(stream, format));
            ++arrayIndex;
            if (dataLength >= stride) continue;
            stream.skipBytes(stride - dataLength);
        }
    }

    public static Matrix4f toRowMajor(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        return new Matrix4f(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33);
    }

    public static GltfModelKey getKey(AssetInfo info) {
        if (info.getKey() instanceof GltfModelKey) {
            return (GltfModelKey)info.getKey();
        }
        return null;
    }

    public static MaterialAdapter getAdapterForMaterial(AssetInfo info, String defName) {
        GltfModelKey key = GltfUtils.getKey(info);
        if (key == null) {
            return null;
        }
        return key.getAdapterForMaterial(defName);
    }

    public static boolean isKeepSkeletonPose(AssetInfo info) {
        GltfModelKey key = GltfUtils.getKey(info);
        if (key == null) {
            return false;
        }
        return key.isKeepSkeletonPose();
    }

    public static LittleEndien getStream(byte[] buffer) {
        return new LittleEndien((InputStream)new DataInputStream(new ByteArrayInputStream(buffer)));
    }

    public static String getAsString(JsonObject parent, String name) {
        JsonElement el = parent.get(name);
        return el == null ? null : el.getAsString();
    }

    public static Integer getAsInteger(JsonObject parent, String name) {
        JsonElement el = parent.get(name);
        return el == null ? null : Integer.valueOf(el.getAsInt());
    }

    public static Integer getAsInteger(JsonObject parent, String name, int defaultValue) {
        JsonElement el = parent.get(name);
        return el == null ? defaultValue : el.getAsInt();
    }

    public static Float getAsFloat(JsonObject parent, String name) {
        JsonElement el = parent.get(name);
        return el == null ? null : Float.valueOf(el.getAsFloat());
    }

    public static Float getAsFloat(JsonObject parent, String name, float defaultValue) {
        JsonElement el = parent.get(name);
        return Float.valueOf(el == null ? defaultValue : el.getAsFloat());
    }

    public static Boolean getAsBoolean(JsonObject parent, String name) {
        JsonElement el = parent.get(name);
        return el == null ? null : Boolean.valueOf(el.getAsBoolean());
    }

    public static Boolean getAsBoolean(JsonObject parent, String name, boolean defaultValue) {
        JsonElement el = parent.get(name);
        return el == null ? defaultValue : el.getAsBoolean();
    }

    public static ColorRGBA getAsColor(JsonObject parent, String name) {
        JsonElement el = parent.get(name);
        if (el == null) {
            return null;
        }
        JsonArray color = el.getAsJsonArray();
        return new ColorRGBA(color.get(0).getAsFloat(), color.get(1).getAsFloat(), color.get(2).getAsFloat(), color.size() > 3 ? color.get(3).getAsFloat() : 1.0f);
    }

    public static ColorRGBA getAsColor(JsonObject parent, String name, ColorRGBA defaultValue) {
        ColorRGBA color = GltfUtils.getAsColor(parent, name);
        return color == null ? defaultValue : color;
    }

    public static void assertNotNull(Object o, String errorMessage) {
        if (o == null) {
            throw new AssetLoadException(errorMessage);
        }
    }

    public static boolean equalsEpsilon(Vector3f v1, Vector3f v2) {
        return FastMath.abs((float)(v1.x - v2.x)) < epsilon && FastMath.abs((float)(v1.y - v2.y)) < epsilon && FastMath.abs((float)(v1.z - v2.z)) < epsilon;
    }

    public static boolean equalsEpsilon(Quaternion q1, Quaternion q2) {
        return FastMath.abs((float)(q1.getX() - q2.getX())) < epsilon && FastMath.abs((float)(q1.getY() - q2.getY())) < epsilon && FastMath.abs((float)(q1.getZ() - q2.getZ())) < epsilon && FastMath.abs((float)(q1.getW() - q2.getW())) < epsilon || FastMath.abs((float)(q1.getX() + q2.getX())) < epsilon && FastMath.abs((float)(q1.getY() + q2.getY())) < epsilon && FastMath.abs((float)(q1.getZ() + q2.getZ())) < epsilon && FastMath.abs((float)(q1.getW() + q2.getW())) < epsilon;
    }

    public static void dumpArray(Object[] array) {
        if (array == null) {
            System.err.println("null");
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            System.err.print(i + ": ");
            if (o instanceof Quaternion) {
                Quaternion q = (Quaternion)o;
                System.err.print("(");
                if ((double)q.getX() > 1.0E-5) {
                    System.err.print(q.getX() + ", ");
                } else {
                    System.err.print("0.0, ");
                }
                if ((double)q.getY() > 1.0E-5) {
                    System.err.print(q.getY() + ", ");
                } else {
                    System.err.print("0.0, ");
                }
                if ((double)q.getZ() > 1.0E-5) {
                    System.err.print(q.getZ() + ", ");
                } else {
                    System.err.print("0.0, ");
                }
                if ((double)q.getW() > 1.0E-5) {
                    System.err.print(q.getW() + ", ");
                } else {
                    System.err.print("0.0, ");
                }
                System.err.println(")");
                continue;
            }
            System.err.println(o.toString() + ", ");
        }
        System.err.println("");
    }

    public static void dumpArray(float[] array) {
        if (array == null) {
            System.err.println("null");
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            float o = array[i];
            System.err.println(i + ": " + o);
        }
        System.err.println("");
    }

    public static Spatial findCommonAncestor(List<Spatial> spatials) {
        HashMap flatParents = new HashMap();
        for (Spatial spatial : spatials) {
            ArrayList<Node> parents = new ArrayList<Node>();
            for (Node parent = spatial.getParent(); parent != null; parent = parent.getParent()) {
                parents.add(0, parent);
            }
            flatParents.put(spatial, parents);
        }
        int index = 0;
        Spatial lastCommonParent = null;
        Spatial parent = null;
        while (true) {
            for (Spatial spatial : flatParents.keySet()) {
                List parents = (List)flatParents.get(spatial);
                if (parents.isEmpty()) continue;
                if (index == parents.size()) {
                    return lastCommonParent;
                }
                Spatial p = (Spatial)parents.get(index);
                if (parent == null) {
                    parent = p;
                    continue;
                }
                if (p == parent) continue;
                return lastCommonParent;
            }
            lastCommonParent = parent;
            parent = null;
            ++index;
        }
    }

    public static void dumpMesh(Mesh m) {
        for (VertexBuffer vertexBuffer : (VertexBuffer[])m.getBufferList().getArray()) {
            Object[] arr;
            Buffer b;
            System.err.println(vertexBuffer.getBufferType());
            System.err.println(vertexBuffer.getFormat());
            if (vertexBuffer.getData() instanceof FloatBuffer) {
                b = (FloatBuffer)vertexBuffer.getData();
                arr = new float[b.capacity()];
                ((FloatBuffer)b).rewind();
                ((FloatBuffer)b).get((float[])arr);
                ((FloatBuffer)b).rewind();
                for (float v : arr) {
                    System.err.print(v + ",");
                }
            }
            if (vertexBuffer.getData() instanceof ShortBuffer) {
                b = (ShortBuffer)vertexBuffer.getData();
                arr = new short[b.capacity()];
                ((ShortBuffer)b).rewind();
                ((ShortBuffer)b).get((short[])arr);
                ((ShortBuffer)b).rewind();
                for (float v : arr) {
                    System.err.print((int)v + ",");
                }
            }
            if (vertexBuffer.getData() instanceof IntBuffer) {
                b = (IntBuffer)vertexBuffer.getData();
                arr = new int[b.capacity()];
                ((IntBuffer)b).rewind();
                ((IntBuffer)b).get((int[])arr);
                ((IntBuffer)b).rewind();
                for (float v : arr) {
                    System.err.print((int)v + ",");
                }
            }
            System.err.println("\n---------------------------");
        }
    }
}

