/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.material;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.material.FbxImage;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.PlaceholderAssets;

public class FbxTexture
extends FbxObject<Texture> {
    private FbxImage media;
    private String uvSet;
    private int wrapModeU = 0;
    private int wrapModeV = 0;

    public FbxTexture(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    public String getUvSet() {
        return this.uvSet;
    }

    @Override
    protected Texture toJmeObject() {
        Image image = null;
        TextureKey key = null;
        if (this.media != null) {
            image = (Image)this.media.getJmeObject();
            key = this.media.getTextureKey();
        }
        if (image == null) {
            image = PlaceholderAssets.getPlaceholderImage((AssetManager)this.assetManager);
        }
        Texture2D tex = new Texture2D(image);
        if (key != null) {
            tex.setKey((AssetKey)key);
            tex.setName(key.getName());
            tex.setAnisotropicFilter(key.getAnisotropy());
        }
        tex.setMinFilter(Texture.MinFilter.Trilinear);
        tex.setMagFilter(Texture.MagFilter.Bilinear);
        if (this.wrapModeU == 0) {
            tex.setWrap(Texture.WrapAxis.S, Texture.WrapMode.Repeat);
        }
        if (this.wrapModeV == 0) {
            tex.setWrap(Texture.WrapAxis.T, Texture.WrapMode.Repeat);
        }
        return tex;
    }

    @Override
    public void fromElement(FbxElement element) {
        super.fromElement(element);
        if (this.getSubclassName().equals("")) {
            for (FbxElement e : element.children) {
                if (!e.id.equals("Type")) continue;
                e.properties.get(0);
            }
            for (FbxElement prop : element.getFbxProperties()) {
                String propName = (String)prop.properties.get(0);
                if (propName.equals("AlphaSource")) continue;
                if (propName.equals("UVSet")) {
                    this.uvSet = (String)prop.properties.get(4);
                    continue;
                }
                if (propName.equals("WrapModeU")) {
                    this.wrapModeU = (Integer)prop.properties.get(4);
                    continue;
                }
                if (!propName.equals("WrapModeV")) continue;
                this.wrapModeV = (Integer)prop.properties.get(4);
            }
        }
    }

    @Override
    public void connectObject(FbxObject object) {
        if (!(object instanceof FbxImage)) {
            this.unsupportedConnectObject(object);
        }
        this.media = (FbxImage)object;
    }

    @Override
    public void connectObjectProperty(FbxObject object, String property) {
        this.unsupportedConnectObjectProperty(object, property);
    }

    private static enum AlphaSource {
        None,
        FromTextureAlpha,
        FromTextureIntensity;

    }
}

