/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.anim;

import com.jme3.animation.BoneTrack;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.fbx.anim.FbxAnimCurve;
import com.jme3.scene.plugins.fbx.anim.FbxAnimCurveNode;
import com.jme3.scene.plugins.fbx.anim.FbxAnimLayer;
import com.jme3.scene.plugins.fbx.anim.FbxAnimStack;
import com.jme3.scene.plugins.fbx.node.FbxNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class FbxToJmeTrack {
    public FbxAnimStack animStack;
    public FbxAnimLayer animLayer;
    public FbxNode node;
    public final transient Map<String, FbxAnimCurveNode> animCurves = new HashMap<String, FbxAnimCurveNode>();

    public long[] getKeyTimes() {
        HashSet<Long> keyFrameTimesSet = new HashSet<Long>();
        for (FbxAnimCurveNode curveNode : this.animCurves.values()) {
            for (FbxAnimCurve curve : curveNode.getCurves()) {
                for (long keyTime : curve.getKeyTimes()) {
                    keyFrameTimesSet.add(keyTime);
                }
            }
        }
        long[] keyFrameTimes = new long[keyFrameTimesSet.size()];
        int i = 0;
        for (Long keyFrameTime : keyFrameTimesSet) {
            keyFrameTimes[i++] = keyFrameTime;
        }
        Arrays.sort(keyFrameTimes);
        return keyFrameTimes;
    }

    public BoneTrack toJmeBoneTrack(int boneIndex, Transform inverseBindPose) {
        return (BoneTrack)this.toJmeTrackInternal(boneIndex, inverseBindPose);
    }

    public SpatialTrack toJmeSpatialTrack() {
        return (SpatialTrack)this.toJmeTrackInternal(-1, null);
    }

    public int countKeyframes() {
        int count = 0;
        for (FbxAnimCurveNode curveNode : this.animCurves.values()) {
            for (FbxAnimCurve curve : curveNode.getCurves()) {
                count += curve.getKeyTimes().length;
            }
        }
        return count;
    }

    public float getDuration() {
        long[] keyframes = this.getKeyTimes();
        return (float)((double)keyframes[keyframes.length - 1] * 2.165150866196751E-11);
    }

    private static void applyInverse(Vector3f translation, Quaternion rotation, Vector3f scale, Transform inverseBindPose) {
        Transform t = new Transform();
        t.setTranslation(translation);
        t.setRotation(rotation);
        if (scale != null) {
            t.setScale(scale);
        }
        t.combineWithParent(inverseBindPose);
        t.getTranslation(translation);
        t.getRotation(rotation);
        if (scale != null) {
            t.getScale(scale);
        }
    }

    private Track toJmeTrackInternal(int boneIndex, Transform inverseBindPose) {
        float duration = this.animStack.getDuration();
        FbxAnimCurveNode translationCurve = this.animCurves.get("Lcl Translation");
        FbxAnimCurveNode rotationCurve = this.animCurves.get("Lcl Rotation");
        FbxAnimCurveNode scalingCurve = this.animCurves.get("Lcl Scaling");
        long[] fbxTimes = this.getKeyTimes();
        float[] times = new float[fbxTimes.length];
        Vector3f[] translations = new Vector3f[fbxTimes.length];
        Quaternion[] rotations = new Quaternion[fbxTimes.length];
        Vector3f[] scales = null;
        if (scalingCurve != null) {
            scales = new Vector3f[fbxTimes.length];
        }
        for (int i = 0; i < fbxTimes.length; ++i) {
            long fbxTime = fbxTimes[i];
            float time = (float)((double)fbxTime * 2.165150866196751E-11);
            if (time > duration) {
                duration = time;
            }
            times[i] = time;
            translations[i] = translationCurve != null ? translationCurve.getVector3Value(fbxTime) : new Vector3f();
            if (rotationCurve != null) {
                rotations[i] = rotationCurve.getQuaternionValue(fbxTime);
                if (i > 0 && rotations[i - 1].dot(rotations[i]) < 0.0f) {
                    rotations[i - 1].negateLocal();
                }
            } else {
                rotations[i] = new Quaternion();
            }
            if (scalingCurve != null) {
                scales[i] = scalingCurve.getVector3Value(fbxTime);
            }
            if (inverseBindPose == null) continue;
            FbxToJmeTrack.applyInverse(translations[i], rotations[i], scales != null ? scales[i] : null, inverseBindPose);
        }
        if (boneIndex == -1) {
            return new SpatialTrack(times, translations, rotations, scales);
        }
        if (scales != null) {
            return new BoneTrack(boneIndex, times, translations, rotations, scales);
        }
        return new BoneTrack(boneIndex, times, translations, rotations);
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + this.animStack.hashCode();
        hash = 79 * hash + this.animLayer.hashCode();
        hash = 79 * hash + this.node.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        FbxToJmeTrack other = (FbxToJmeTrack)obj;
        return this.node == other.node && this.animStack == other.animStack && this.animLayer == other.animLayer;
    }
}

