/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.anim;

import com.jme3.asset.AssetManager;
import com.jme3.math.FastMath;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.obj.FbxObject;

public class FbxAnimCurve
extends FbxObject {
    private long[] keyTimes;
    private float[] keyValues;

    public FbxAnimCurve(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    @Override
    public void fromElement(FbxElement element) {
        super.fromElement(element);
        for (FbxElement e : element.children) {
            if (e.id.equals("KeyTime")) {
                this.keyTimes = (long[])e.properties.get(0);
                continue;
            }
            if (!e.id.equals("KeyValueFloat")) continue;
            this.keyValues = (float[])e.properties.get(0);
        }
        long time = -1L;
        for (int i = 0; i < this.keyTimes.length; ++i) {
            if (time >= this.keyTimes[i]) {
                throw new UnsupportedOperationException("Keyframe times must be sequential, but they are not.");
            }
            time = this.keyTimes[i];
        }
    }

    public long[] getKeyTimes() {
        return this.keyTimes;
    }

    public float getValueAtTime(long time) {
        if (this.keyTimes.length == 0) {
            return 0.0f;
        }
        if (time <= this.keyTimes[0]) {
            return this.keyValues[0];
        }
        if (time >= this.keyTimes[this.keyTimes.length - 1]) {
            return this.keyValues[this.keyValues.length - 1];
        }
        int startFrame = 0;
        int endFrame = 1;
        int lastFrame = this.keyTimes.length - 1;
        for (int i = 0; i < lastFrame && this.keyTimes[i] < time; ++i) {
            startFrame = i;
            endFrame = i + 1;
        }
        long keyTime1 = this.keyTimes[startFrame];
        float keyValue1 = this.keyValues[startFrame];
        long keyTime2 = this.keyTimes[endFrame];
        float keyValue2 = this.keyValues[endFrame];
        if (keyTime2 == time) {
            return keyValue2;
        }
        long prevToNextDelta = keyTime2 - keyTime1;
        long prevToCurrentDelta = time - keyTime1;
        float lerpAmount = (float)prevToCurrentDelta / (float)prevToNextDelta;
        return FastMath.interpolateLinear((float)lerpAmount, (float)keyValue1, (float)keyValue2);
    }

    protected Object toJmeObject() {
        throw new UnsupportedOperationException("No jME3 object conversion available");
    }

    @Override
    public void connectObject(FbxObject object) {
        this.unsupportedConnectObject(object);
    }

    @Override
    public void connectObjectProperty(FbxObject object, String property) {
        this.unsupportedConnectObjectProperty(object, property);
    }
}

