/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.example.qcon;

import org.jmock.Expectations;
import org.jmock.example.qcon.DJ;
import org.jmock.example.qcon.MediaControl;
import org.jmock.example.qcon.Playlist;
import org.jmock.integration.junit3.MockObjectTestCase;
import org.jmock.internal.ExpectationBuilder;

public class DJTests
extends MockObjectTestCase {
    Playlist playlist = (Playlist)this.mock(Playlist.class);
    MediaControl mediaControl = (MediaControl)this.mock(MediaControl.class);
    DJ dj = new DJ(this.playlist, this.mediaControl);
    private static final String LOCATION_A = "location-a";
    private static final String TRACK_A = "track-a";
    private static final String LOCATION_B = "location-b";
    private static final String TRACK_B = "track-b";

    public void setUp() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Playlist)this.allowing(DJTests.this.playlist)).hasTrackFor(DJTests.LOCATION_A);
                this.will(1.returnValue((Object)true));
                ((Playlist)this.allowing(DJTests.this.playlist)).trackFor(DJTests.LOCATION_A);
                this.will(1.returnValue((Object)DJTests.TRACK_A));
                ((Playlist)this.allowing(DJTests.this.playlist)).hasTrackFor(DJTests.LOCATION_B);
                this.will(1.returnValue((Object)true));
                ((Playlist)this.allowing(DJTests.this.playlist)).trackFor(DJTests.LOCATION_B);
                this.will(1.returnValue((Object)DJTests.TRACK_B));
                ((Playlist)this.allowing(DJTests.this.playlist)).hasTrackFor((String)this.with(1.any(String.class)));
                this.will(1.returnValue((Object)false));
            }
        });
    }

    public void testStartsPlayingTrackForCurrentLocationWhenLocationFirstDetected() {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((MediaControl)this.oneOf(DJTests.this.mediaControl)).play(DJTests.TRACK_A);
            }
        });
        this.dj.locationChangedTo(LOCATION_A);
    }

    public void testPlaysTrackForCurrentLocationWhenPreviousTrackFinishesIfLocationChangedWhileTrackWasPlaying() {
        this.startingIn(LOCATION_A);
        this.dj.locationChangedTo(LOCATION_B);
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((MediaControl)this.oneOf(DJTests.this.mediaControl)).play(DJTests.TRACK_B);
            }
        });
        this.dj.mediaFinished();
    }

    public void testDoesNotPlayTrackAgainIfStillInTheSameLocation() {
        this.startingIn(LOCATION_A);
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((MediaControl)this.never(DJTests.this.mediaControl)).play((String)this.with(4.any(String.class)));
            }
        });
        this.dj.mediaFinished();
    }

    public void testPlaysNewTrackAsSoonAsLocationChangesIfPreviousTrackFinishedWhileInSameLocation() {
        this.startingIn(LOCATION_A);
        this.dj.mediaFinished();
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((MediaControl)this.oneOf(DJTests.this.mediaControl)).play(DJTests.TRACK_B);
            }
        });
        this.dj.locationChangedTo(LOCATION_B);
    }

    private void startingIn(String initialLocation) {
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((MediaControl)this.oneOf(DJTests.this.mediaControl)).play((String)this.with(6.any(String.class)));
            }
        });
        this.dj.locationChangedTo(initialLocation);
    }
}

