/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl;

import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.WCWidth;

public class DefaultHighlighter
implements Highlighter {
    @Override
    public AttributedString highlight(LineReader reader, String buffer) {
        int underlineStart = -1;
        int underlineEnd = -1;
        int negativeStart = -1;
        int negativeEnd = -1;
        String search = reader.getSearchTerm();
        if (search != null && search.length() > 0 && (underlineStart = buffer.indexOf(search)) >= 0) {
            underlineEnd = underlineStart + search.length() - 1;
        }
        if (reader.getRegionActive() != LineReader.RegionType.NONE) {
            negativeStart = reader.getRegionMark();
            if (negativeStart > (negativeEnd = reader.getBuffer().cursor())) {
                int x = negativeEnd;
                negativeEnd = negativeStart;
                negativeStart = x;
            }
            if (reader.getRegionActive() == LineReader.RegionType.LINE) {
                while (negativeStart > 0 && reader.getBuffer().atChar(negativeStart - 1) != 10) {
                    --negativeStart;
                }
                while (negativeEnd < reader.getBuffer().length() - 1 && reader.getBuffer().atChar(negativeEnd + 1) != 10) {
                    ++negativeEnd;
                }
            }
        }
        AttributedStringBuilder sb = new AttributedStringBuilder();
        for (int i = 0; i < buffer.length(); ++i) {
            char c;
            if (i == underlineStart) {
                sb.style(sb.style().underline());
            }
            if (i == negativeStart) {
                sb.style(sb.style().inverse());
            }
            if ((c = buffer.charAt(i)) == '\t' || c == '\n') {
                sb.append(c);
            } else if (c < ' ') {
                sb.style(sb.style().inverseNeg()).append('^').append((char)(c + 64)).style(sb.style().inverseNeg());
            } else {
                int w = WCWidth.wcwidth((int)c);
                if (w > 0) {
                    sb.append(c);
                }
            }
            if (i == underlineEnd) {
                sb.style(sb.style().underlineOff());
            }
            if (i != negativeEnd) continue;
            sb.style(sb.style().inverseOff());
        }
        return sb.toAttributedString();
    }
}

