/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.webgraph;

import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongSkippableIterator;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.jgrapht.graph.AbstractGraph;

public abstract class AbstractImmutableBigGraphAdapter<E extends LongLongPair>
extends AbstractGraph<Long, E> {
    protected final ImmutableGraph immutableGraph;
    protected final long n;
    protected long m = -1L;

    protected AbstractImmutableBigGraphAdapter(ImmutableGraph immutableGraph) {
        this.immutableGraph = immutableGraph;
        this.n = immutableGraph.numNodes();
    }

    public Set<E> getAllEdges(Long sourceVertex, Long targetVertex) {
        if (sourceVertex == null || targetVertex == null) {
            return null;
        }
        long x = sourceVertex;
        long y = targetVertex;
        if (x < 0L || x >= this.n || y < 0L || y >= this.n) {
            return null;
        }
        return this.containsEdgeFast(x, y) ? Collections.singleton(this.makeEdge(x, y)) : Collections.emptySet();
    }

    protected abstract E makeEdge(long var1, long var3);

    public E getEdge(Long sourceVertex, Long targetVertex) {
        long y;
        if (sourceVertex == null || targetVertex == null) {
            return null;
        }
        long x = sourceVertex;
        return this.containsEdgeFast(x, y = targetVertex.longValue()) ? (E)this.makeEdge(x, y) : null;
    }

    public Supplier<Long> getVertexSupplier() {
        return null;
    }

    public Supplier<E> getEdgeSupplier() {
        return null;
    }

    public E addEdge(Long sourceVertex, Long targetVertex) {
        throw new UnsupportedOperationException();
    }

    public boolean addEdge(Long sourceVertex, Long targetVertex, E e) {
        throw new UnsupportedOperationException();
    }

    public Long addVertex() {
        throw new UnsupportedOperationException();
    }

    public boolean addVertex(Long v) {
        throw new UnsupportedOperationException();
    }

    public boolean containsEdge(Long sourceVertex, Long targetVertex) {
        if (sourceVertex == null || targetVertex == null) {
            return false;
        }
        return this.containsEdgeFast(sourceVertex, targetVertex);
    }

    protected boolean containsEdgeFast(long x, long y) {
        long target;
        if (x < 0L || x >= this.n || y < 0L || y >= this.n) {
            return false;
        }
        LazyLongIterator successors = this.immutableGraph.successors(x);
        if (successors instanceof LazyLongSkippableIterator) {
            return y == ((LazyLongSkippableIterator)successors).skipTo(y);
        }
        while ((target = successors.nextLong()) != -1L) {
            if (target != y) continue;
            return true;
        }
        return false;
    }

    public boolean containsVertex(Long v) {
        if (v == null) {
            return false;
        }
        long x = v;
        return x >= 0L && x < this.n;
    }

    public E removeEdge(Long sourceVertex, Long targetVertex) {
        throw new UnsupportedOperationException();
    }

    public boolean removeEdge(E e) {
        throw new UnsupportedOperationException();
    }

    public boolean removeVertex(Long v) {
        throw new UnsupportedOperationException();
    }

    public Set<Long> vertexSet() {
        return LongSets.fromTo((long)0L, (long)this.n);
    }

    public Long getEdgeSource(E e) {
        return e.leftLong();
    }

    public Long getEdgeTarget(E e) {
        return e.rightLong();
    }

    public double getEdgeWeight(E e) {
        return 1.0;
    }

    public void setEdgeWeight(E e, double weight) {
        if (weight != 1.0) {
            throw new UnsupportedOperationException();
        }
    }
}

