/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.sux4j;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.sux4j.util.EliasFanoIndexedMonotoneLongBigList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.sux4j.AbstractSuccinctGraph;

public abstract class AbstractSuccinctUndirectedGraph<E>
extends AbstractSuccinctGraph<E> {
    private static final long serialVersionUID = 0L;

    public AbstractSuccinctUndirectedGraph(int n, int m) {
        super(n, m);
    }

    public int inDegreeOf(Integer vertex) {
        return this.degreeOf(vertex);
    }

    public int outDegreeOf(Integer vertex) {
        return this.degreeOf(vertex);
    }

    protected boolean containsEdge(EliasFanoIndexedMonotoneLongBigList successors, int x, int y) {
        if (x > y) {
            int t = x;
            x = y;
            y = t;
        }
        return successors.indexOfUnsafe(((long)x << this.sourceShift) + (long)y) != -1L;
    }

    public GraphType getType() {
        return new DefaultGraphType.Builder().directed().weighted(false).modifiable(false).allowMultipleEdges(false).allowSelfLoops(true).build();
    }

    protected static final class CumulativeDegrees<E>
    implements LongIterator {
        private final int n;
        private int x = -1;
        private long cumul = 0L;
        private final Function<Integer, Iterable<E>> succ;
        private final boolean sorted;
        private final Graph<Integer, E> graph;

        protected CumulativeDegrees(Graph<Integer, E> graph, boolean sorted, Function<Integer, Iterable<E>> succ) {
            this.n = (int)graph.iterables().vertexCount();
            this.graph = graph;
            this.succ = succ;
            this.sorted = sorted;
        }

        public boolean hasNext() {
            return this.x < this.n;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.x == -1) {
                return ++this.x;
            }
            int d = 0;
            if (this.sorted) {
                for (E e : this.succ.apply(this.x)) {
                    if (this.x > (Integer)Graphs.getOppositeVertex(this.graph, e, (Object)this.x)) continue;
                    ++d;
                }
            } else {
                for (E e : this.succ.apply(this.x)) {
                    if (this.x < (Integer)Graphs.getOppositeVertex(this.graph, e, (Object)this.x)) continue;
                    ++d;
                }
            }
            ++this.x;
            return this.cumul += (long)d;
        }
    }

    protected static final class CumulativeSuccessors<E>
    implements LongIterator {
        private final Graph<Integer, E> graph;
        private final long n;
        private final int sourceShift;
        private final Function<Integer, Iterable<E>> succ;
        private final boolean sorted;
        private int x = -1;
        private int d;
        private int i;
        private int e;
        private long next = -1L;
        private int[] s = IntArrays.EMPTY_ARRAY;

        protected CumulativeSuccessors(Graph<Integer, E> graph, boolean sorted, Function<Integer, Iterable<E>> succ) {
            this.n = (int)graph.iterables().vertexCount();
            this.sourceShift = Fast.ceilLog2((long)this.n);
            this.graph = graph;
            this.sorted = sorted;
            this.succ = succ;
        }

        public boolean hasNext() {
            if (this.next != -1L) {
                return true;
            }
            if ((long)this.x == this.n) {
                return false;
            }
            while (this.i == this.d) {
                if ((long)(++this.x) == this.n) {
                    return false;
                }
                int d = 0;
                for (E e : this.succ.apply(this.x)) {
                    int y = (Integer)Graphs.getOppositeVertex(this.graph, e, (Object)this.x);
                    if (this.sorted) {
                        if (this.x > y) continue;
                        this.s = IntArrays.grow((int[])this.s, (int)(d + 1));
                        this.s[d++] = y;
                        continue;
                    }
                    if (this.x < y) continue;
                    this.s = IntArrays.grow((int[])this.s, (int)(d + 1));
                    this.s[d++] = y;
                }
                Arrays.sort(this.s, 0, d);
                this.d = d;
                this.i = 0;
            }
            this.next = this.sorted ? (long)this.s[this.i] + ((long)this.x << this.sourceShift) : (long)this.s[this.i] + (long)this.x * this.n - (long)this.e++;
            ++this.i;
            return true;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long result = this.next;
            this.next = -1L;
            return result;
        }
    }
}

