/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.sux4j;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.Serializable;
import java.util.Set;
import java.util.function.Supplier;
import org.jgrapht.graph.AbstractGraph;

public abstract class AbstractSuccinctGraph<E>
extends AbstractGraph<Integer, E>
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected static final String UNMODIFIABLE = "this graph is unmodifiable";
    protected final int n;
    protected final int m;
    protected final int sourceShift;
    protected final long targetMask;

    public AbstractSuccinctGraph(int n, int m) {
        this.n = n;
        this.m = m;
        this.sourceShift = Fast.ceilLog2((int)n);
        this.targetMask = (1L << this.sourceShift) - 1L;
    }

    public Set<Integer> vertexSet() {
        return IntSets.fromTo((int)0, (int)this.n);
    }

    protected boolean assertVertexExist(Integer v) {
        if (v < 0 || v >= this.n) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public boolean containsVertex(Integer v) {
        return v >= 0 && v < this.n;
    }

    public Set<E> getAllEdges(Integer sourceVertex, Integer targetVertex) {
        Object edge = this.getEdge(sourceVertex, targetVertex);
        return edge == null ? ObjectSets.emptySet() : ObjectSets.singleton((Object)edge);
    }

    public Supplier<Integer> getVertexSupplier() {
        return null;
    }

    public Supplier<E> getEdgeSupplier() {
        return null;
    }

    public E addEdge(Integer sourceVertex, Integer targetVertex) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean addEdge(Integer sourceVertex, Integer targetVertex, E e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public Integer addVertex() {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean addVertex(Integer v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public E removeEdge(Integer sourceVertex, Integer targetVertex) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean removeEdge(E e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public boolean removeVertex(Integer v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    public double getEdgeWeight(E e) {
        return 1.0;
    }

    public void setEdgeWeight(E e, double weight) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }
}

