/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.sux4j;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.sux4j.AbstractSuccinctGraph;

public abstract class AbstractSuccinctDirectedGraph<E>
extends AbstractSuccinctGraph<E> {
    private static final long serialVersionUID = 0L;

    public AbstractSuccinctDirectedGraph(int n, int m) {
        super(n, m);
    }

    public int degreeOf(Integer vertex) {
        return this.inDegreeOf(vertex) + this.outDegreeOf(vertex);
    }

    public GraphType getType() {
        return new DefaultGraphType.Builder().directed().weighted(false).modifiable(false).allowMultipleEdges(false).allowSelfLoops(true).build();
    }

    protected static final class CumulativeDegrees
    implements LongIterator {
        private final Function<Integer, Integer> degreeOf;
        private final int n;
        private int i = -1;
        private long cumul = 0L;

        protected CumulativeDegrees(int n, Function<Integer, Integer> degreeOf) {
            this.n = n;
            this.degreeOf = degreeOf;
        }

        public boolean hasNext() {
            return this.i < this.n;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.i == -1) {
                return ++this.i;
            }
            return this.cumul += (long)this.degreeOf.apply(this.i++).intValue();
        }
    }

    protected static final class CumulativeSuccessors<E>
    implements LongIterator {
        private final Graph<Integer, E> graph;
        private final long n;
        private final int sourceShift;
        private final Function<Integer, Iterable<E>> succ;
        private final boolean strict;
        private int x = -1;
        private int d;
        private int i;
        private int e;
        private long next = -1L;
        private int[] s = IntArrays.EMPTY_ARRAY;

        protected CumulativeSuccessors(Graph<Integer, E> graph, Function<Integer, Iterable<E>> succ, boolean strict) {
            this.n = graph.iterables().vertexCount();
            this.sourceShift = Fast.ceilLog2((long)this.n);
            this.graph = graph;
            this.succ = succ;
            this.strict = strict;
        }

        public boolean hasNext() {
            if (this.next != -1L) {
                return true;
            }
            if ((long)this.x == this.n) {
                return false;
            }
            while (this.i == this.d) {
                if ((long)(++this.x) == this.n) {
                    return false;
                }
                int d = 0;
                for (E e : this.succ.apply(this.x)) {
                    this.s = IntArrays.grow((int[])this.s, (int)(d + 1));
                    this.s[d++] = (Integer)Graphs.getOppositeVertex(this.graph, e, (Object)this.x);
                }
                Arrays.sort(this.s, 0, d);
                this.d = d;
                this.i = 0;
            }
            this.next = this.strict ? (long)this.s[this.i] + ((long)this.x << this.sourceShift) : (long)this.s[this.i] + (long)this.x * this.n - (long)this.e++;
            ++this.i;
            return true;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long result = this.next;
            this.next = -1L;
            return result;
        }
    }
}

