/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public abstract class TimeUnitFormat {
    private static final long NANOS_IN_ONE_MILLIS = 1000000L;
    private static final long NANOS_IN_ONE_SECOND = 1000000000L;
    private static final long NANOS_IN_ONE_MINUTE = 60000000000L;

    public static String getTimeString(long duration, TimeUnit timeUnit) {
        return TimeUnitFormat.getTimeString(timeUnit.toNanos(duration));
    }

    public static String getTimeString(long nanos) {
        DecimalFormat numberFormat = new DecimalFormat("###.##", new DecimalFormatSymbols(Locale.UK));
        if (nanos < 1000000L) {
            return nanos + " nanos";
        }
        if (nanos < 1000000000L) {
            return numberFormat.format((float)nanos / 1000000.0f) + " millis";
        }
        if (nanos < 60000000000L) {
            return numberFormat.format((float)nanos / 1.0E9f) + " secs";
        }
        return numberFormat.format((float)nanos / 6.0E10f) + " minutes";
    }
}

