/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jfrog.common.StreamSupportUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetStream {
    private static final Logger log = LoggerFactory.getLogger(ResultSetStream.class);
    private ResultSet resultset;
    private int index = 0;
    private CompletableFuture<SQLException> onException;

    public static <R> Stream<R> asStream(ResultSet resultset, ResultSetToObject<R> convert, CompletableFuture<SQLException> onException) {
        return new ResultSetStream(resultset, onException).asStreamObject(convert);
    }

    public static Stream<ResultSet> asStream(ResultSet resultset, CompletableFuture<SQLException> onException) {
        return new ResultSetStream(resultset, onException).asStream();
    }

    private ResultSetStream(ResultSet resultset, CompletableFuture<SQLException> onException) {
        this.resultset = resultset;
        this.onException = onException;
    }

    public int getIndex() {
        return this.index;
    }

    private <R> Stream<R> asStreamObject(ResultSetToObject<R> convert) {
        return this.asStream().map(it -> {
            try {
                return convert.apply((ResultSet)it);
            }
            catch (SQLException e) {
                this.onException.complete(e);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    public Stream<ResultSet> asStream() {
        if (this.resultset == null) {
            return Stream.empty();
        }
        Function<Integer, ResultSet> generator = i -> {
            try {
                if (this.resultset.next()) {
                    this.index = i;
                    return this.resultset;
                }
            }
            catch (SQLException e) {
                if (this.onException != null) {
                    this.onException.complete(e);
                }
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
            return null;
        };
        Stream generated = (Stream)StreamSupportUtils.generateTillNull(generator).filter(Objects::nonNull).onClose(this::close);
        return StreamSupportUtils.autoClose(generated);
    }

    private void close() {
        if (this.resultset != null) {
            try {
                this.resultset.close();
                this.resultset = null;
            }
            catch (SQLException e) {
                log.trace("Could not close JDBC result set", (Throwable)e);
            }
            catch (Exception e) {
                log.trace("Unexpected exception when closing JDBC result set", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @FunctionalInterface
    public static interface ResultSetToObject<R> {
        public R apply(ResultSet var1) throws SQLException;
    }
}

