/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MultimapCollectors {
    public static <K, V, A extends Multimap<K, V>> Collector<Map.Entry<K, V>, A, A> multimapFromEntrySet(Supplier<A> supplier) {
        return Collector.of(supplier, (acc, entry) -> acc.put(entry.getKey(), entry.getValue()), (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        }, new Collector.Characteristics[0]);
    }

    public static <T, K, V> MultimapCollector<T, K, V> toMultimap(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return new MultimapCollector<T, K, V>(keyMapper, valueMapper);
    }

    public static <T, V> MultimapCollector<T, V, T> toMultimap(Function<T, V> keyMapper) {
        return new MultimapCollector<Object, V, Object>(keyMapper, v -> v);
    }

    public static class MultimapCollector<T, K, V>
    implements Collector<T, Multimap<K, V>, Multimap<K, V>> {
        private final Function<T, K> keyMapper;
        private final Function<T, V> valueMapper;

        MultimapCollector(Function<T, K> keyMapper, Function<T, V> valueMapper) {
            this.keyMapper = keyMapper;
            this.valueMapper = valueMapper;
        }

        @Override
        public Supplier<Multimap<K, V>> supplier() {
            return HashMultimap::create;
        }

        @Override
        public BiConsumer<Multimap<K, V>, T> accumulator() {
            return (map, element) -> map.put(this.keyMapper.apply(element), this.valueMapper.apply(element));
        }

        @Override
        public BinaryOperator<Multimap<K, V>> combiner() {
            return (target, source) -> {
                target.putAll(source);
                return target;
            };
        }

        @Override
        public Function<Multimap<K, V>, Multimap<K, V>> finisher() {
            return map -> map;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return ImmutableSet.of((Object)((Object)Collector.Characteristics.IDENTITY_FINISH));
        }
    }
}

