/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jfrog.common.LazyCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyCacheImpl<K, V>
implements LazyCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LazyCacheImpl.class);
    private final Cache<K, V> cache;
    private final Cache<K, V> cacheDummy = CacheBuilder.newBuilder().maximumSize(0L).build();
    private final Function<K, V> fetchFunction;
    private final Function<List<K>, Map<K, V>> fetchMany;
    final Supplier<Map<K, V>> fetchAll;
    final ReentrantLock exclusiveCacheLock = new ReentrantLock();

    public LazyCacheImpl(Function<K, V> fetchFunction, Function<List<K>, Map<K, V>> fetchMany, Supplier<Map<K, V>> fetchAll) {
        this(fetchFunction, fetchMany, fetchAll, 5);
    }

    public LazyCacheImpl(Function<K, V> fetchFunction, Function<List<K>, Map<K, V>> fetchMany, Supplier<Map<K, V>> fetchAll, int expireInMinutes) {
        this.fetchFunction = fetchFunction;
        this.fetchMany = fetchMany;
        this.fetchAll = fetchAll;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)expireInMinutes, TimeUnit.MINUTES).build();
    }

    @Override
    public Optional<V> value(K lookup) {
        Object value = this.getCache().getIfPresent(lookup);
        if (value == null && (value = this.fetchFunction.apply(lookup)) != null) {
            this.getCache().put(lookup, value);
        }
        return Optional.ofNullable(value);
    }

    @Override
    public V valueFromCache(K lookup) {
        return (V)this.getCache().getIfPresent(lookup);
    }

    @Override
    public Map<K, Optional<V>> getValues(Collection<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<K, V> allCached = this.getAllPresent(keys);
        List<K> missing = this.getMissingInCache(keys, allCached);
        Map<K, V> fetched = this.fetchMany.apply(missing);
        this.putAll(fetched);
        return this.getBestVersion(keys, allCached, fetched);
    }

    public V getValues(K lookup) {
        return (V)this.getCache().getIfPresent(lookup);
    }

    @Override
    public void put(K key, V value) {
        this.getCache().put(key, value);
    }

    @Override
    public void putAll(Map<K, V> entries) {
        entries.forEach((k, v) -> this.getCache().put(k, v));
    }

    @Override
    public void limitCachingToCurrentThread() {
        this.exclusiveCacheLock.lock();
        log.debug("Thread '{}' (id: '{}') acquired lock on bi-directional cache", (Object)Thread.currentThread().getName(), (Object)Thread.currentThread().getId());
        this.invalidateAll();
        log.info("Cache disabled!");
    }

    @Override
    public void invalidateAll() {
        this.getCache().invalidateAll();
    }

    @Override
    public boolean invalidate(K k) {
        log.debug("Invalidating cache entry with key '{}'", k);
        Object v = this.getCache().getIfPresent(k);
        if (v != null) {
            this.getCache().invalidate(k);
        }
        return v != null;
    }

    @Override
    public void invalidate(Collection<K> keys) {
        this.getCache().invalidateAll(keys);
    }

    @Override
    public void removeCachingLimit(Class clazz) {
        this.invalidateAll();
        this.exclusiveCacheLock.unlock();
        log.info("Enabled cache for '{}'", (Object)clazz.getSimpleName());
    }

    @Override
    public LazyCache<K, V> prefetch() {
        this.invalidateAll();
        Map<K, V> entries = this.fetchAll.get();
        this.putAll(entries);
        return this;
    }

    @Override
    public Map<K, V> asMap() {
        return this.cache.asMap();
    }

    <T, U> Map<T, Optional<U>> getBestVersion(Collection<T> search, Map<T, U> cached, Map<T, U> fetched) {
        return search.stream().collect(Collectors.toMap(Function.identity(), g -> {
            if (fetched.containsKey(g)) {
                return Optional.of(fetched.get(g));
            }
            return Optional.ofNullable(cached.get(g));
        }));
    }

    private List<K> getMissingInCache(Collection<K> keys, Map<K, V> allCached) {
        return keys.stream().filter(l -> Objects.isNull(allCached.get(l))).collect(Collectors.toList());
    }

    private Map<K, V> getAllPresent(Collection<K> keys) {
        return this.getCache().getAllPresent(keys);
    }

    Cache<K, V> getCache() {
        return this.isCacheEnabled() || this.exclusiveCacheLock.isHeldByCurrentThread() ? this.cache : this.cacheDummy;
    }

    boolean isCacheEnabled() {
        return !this.exclusiveCacheLock.isLocked();
    }

    public long getCacheSize() {
        return this.getCache().size();
    }
}

