/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.jfrog.common.JsonMergeException;
import org.jfrog.common.MapperUtilsBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils
extends MapperUtilsBase {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final JsonUtils instance = new JsonUtils(JsonInclude.Include.NON_NULL);
    private static final JsonUtils instanceWithAll = new JsonUtils(JsonInclude.Include.ALWAYS);

    protected JsonUtils(final JsonInclude.Include serializationInclusion) {
        super(new ObjectMapper(){
            {
                this.setSerializationInclusion(serializationInclusion);
                this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                this.registerModule((Module)new ParameterNamesModule());
            }
        });
    }

    protected JsonUtils(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public static synchronized JsonUtils getInstance() {
        return instance;
    }

    public static synchronized JsonUtils getInstanceSerializingNulls() {
        return instanceWithAll;
    }

    public static String toJsonMerge(Object entity, Set<String> fieldsToInclude) {
        JsonNode tree = JsonUtils.getInstanceSerializingNulls().valueToTree(entity);
        Iterator i = tree.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            if (fieldsToInclude.contains(entry.getKey())) continue;
            i.remove();
        }
        return JsonUtils.getInstanceSerializingNulls().valueToString(tree);
    }

    public static synchronized JsonUtils createInstance(ObjectMapper objectMapper) {
        return new JsonUtils(objectMapper);
    }

    public static <I, T extends I> I jsonMerge(I originalModel, String patch, Class<T> modelType, @Nullable Consumer<JsonNode> validatePatchResult) {
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        try {
            JsonNode entity = mapper.valueToTree(originalModel);
            JsonMergePatch patchTool = (JsonMergePatch)mapper.readValue(patch, JsonMergePatch.class);
            JsonNode modifiedEntity = patchTool.apply(entity);
            if (validatePatchResult != null) {
                validatePatchResult.accept(modifiedEntity);
            }
            return (I)mapper.treeToValue((TreeNode)modifiedEntity, modelType);
        }
        catch (JsonPatchException | IOException e) {
            String message = "Failed to parse json patch content";
            log.trace(message, e);
            throw new JsonMergeException(message);
        }
    }
}

