/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class DockerUtils {
    public static String getConfigDigest(String manifest) throws IOException {
        JsonNode manifestTree = DockerUtils.createMapper().readTree(manifest);
        JsonNode schemaVersion = manifestTree.get("schemaVersion");
        if (schemaVersion == null) {
            throw new IllegalStateException("Could not find 'schemaVersion' in manifest");
        }
        if (schemaVersion.asInt() == 1) {
            throw new IllegalStateException("Docker build info is not supported for docker V1 images");
        }
        JsonNode config = manifestTree.get("config");
        if (config == null) {
            throw new IllegalStateException("Could not find 'config' in manifest");
        }
        JsonNode digest = config.get("digest");
        if (digest == null) {
            throw new IllegalStateException("Could not find config digest in manifest");
        }
        return org.apache.commons.lang3.StringUtils.remove((String)digest.toString(), (String)"\"");
    }

    public static String getImageDigestFromFatManifest(String manifest, String os, String arch) throws IOException {
        if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{os, arch})) {
            return "";
        }
        JsonNode fatManifestTree = DockerUtils.createMapper().readTree(manifest);
        JsonNode manifests = fatManifestTree.get("manifests");
        if (manifests == null) {
            throw new IllegalStateException("Could not find 'manifests' in fat-manifest");
        }
        for (JsonNode manifestInfo : manifests) {
            JsonNode manifestInfoPlatform = manifestInfo.get("platform");
            if (manifestInfoPlatform == null) continue;
            JsonNode manifestOs = manifestInfoPlatform.get("os");
            JsonNode manifestArch = manifestInfoPlatform.get("architecture");
            if (manifestOs == null || manifestArch == null || !os.equals(manifestOs.asText()) || !arch.equals(manifestArch.asText())) continue;
            return manifestInfo.get("digest").asText();
        }
        return "";
    }

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public static List<String> getLayersDigests(String manifestContent) throws IOException {
        ArrayList<String> dockerLayersDependencies = new ArrayList<String>();
        JsonNode manifest = DockerUtils.createMapper().readTree(manifestContent);
        JsonNode schemaVersion = manifest.get("schemaVersion");
        if (schemaVersion == null) {
            throw new IllegalStateException("Could not find 'schemaVersion' in manifest");
        }
        boolean isSchemeVersion1 = schemaVersion.asInt() == 1;
        JsonNode fsLayers = DockerUtils.getFsLayers(manifest, isSchemeVersion1);
        for (JsonNode fsLayer : fsLayers) {
            if (DockerUtils.isForeignLayer(isSchemeVersion1, fsLayer)) continue;
            JsonNode blobSum = DockerUtils.getBlobSum(isSchemeVersion1, fsLayer);
            dockerLayersDependencies.add(blobSum.asText());
        }
        dockerLayersDependencies.add(DockerUtils.getConfigDigest(manifestContent));
        String manifestSha1 = DockerUtils.toSha1(manifestContent);
        dockerLayersDependencies.add("sha1:" + manifestSha1);
        return dockerLayersDependencies;
    }

    private static String toSha1(String data) {
        try {
            MessageDigest msdDigest = MessageDigest.getInstance("SHA-1");
            msdDigest.update(data.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])msdDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to convert manifest.json content to SHA1.");
        }
    }

    private static JsonNode getFsLayers(JsonNode manifest, boolean isSchemeVersion1) {
        JsonNode fsLayers = isSchemeVersion1 ? manifest.get("fsLayers") : manifest.get("layers");
        if (fsLayers == null) {
            throw new IllegalStateException("Could not find 'fsLayers' or 'layers' in manifest");
        }
        return fsLayers;
    }

    private static boolean isForeignLayer(boolean isSchemeVersion1, JsonNode fsLayer) {
        return !isSchemeVersion1 && fsLayer.get("mediaType") != null && fsLayer.get("mediaType").asText().equals("application/vnd.docker.image.rootfs.foreign.diff.tar.gzip");
    }

    private static JsonNode getBlobSum(boolean isSchemeVersion1, JsonNode fsLayer) {
        JsonNode blobSum = isSchemeVersion1 ? fsLayer.get("blobSum") : fsLayer.get("digest");
        if (blobSum == null) {
            throw new IllegalStateException("Could not find 'blobSub' or 'digest' in manifest");
        }
        return blobSum;
    }

    public static String getShaVersion(String digest) {
        return org.apache.commons.lang3.StringUtils.substring((String)digest, (int)0, (int)org.apache.commons.lang3.StringUtils.indexOf((CharSequence)digest, (CharSequence)":"));
    }

    public static String getShaValue(String digest) {
        return org.apache.commons.lang3.StringUtils.substring((String)digest, (int)(org.apache.commons.lang3.StringUtils.indexOf((CharSequence)digest, (CharSequence)":") + 1));
    }

    public static String digestToFileName(String digest) {
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)digest, (CharSequence)"sha1")) {
            return "manifest.json";
        }
        return DockerUtils.getShaVersion(digest) + "__" + DockerUtils.getShaValue(digest);
    }

    public static int getNumberOfDependentLayers(String imageContent) throws IOException {
        JsonNode history = DockerUtils.createMapper().readTree(imageContent).get("history");
        if (history == null) {
            throw new IllegalStateException("Could not find 'history' tag");
        }
        int layersNum = history.size();
        boolean newImageLayers = true;
        for (int i = history.size() - 1; i >= 0; --i) {
            String createdBy;
            if (newImageLayers) {
                --layersNum;
            }
            JsonNode layer = history.get(i);
            JsonNode emptyLayer = layer.get("empty_layer");
            if (!newImageLayers && emptyLayer != null) {
                --layersNum;
            }
            if (layer.get("created_by") == null || !(createdBy = layer.get("created_by").textValue()).contains("ENTRYPOINT") && !createdBy.contains("MAINTAINER")) continue;
            newImageLayers = false;
        }
        return layersNum;
    }

    public static String fileNameToDigest(String fileName) {
        return org.apache.commons.lang3.StringUtils.replace((String)fileName, (String)"__", (String)":");
    }

    public static String getImagePath(String imageTag) {
        String imageVersion;
        String imageName;
        int indexOfSlash = imageTag.indexOf("/");
        int indexOfLastColon = imageTag.lastIndexOf(":");
        if (indexOfLastColon < 0 || indexOfLastColon < indexOfSlash) {
            imageName = imageTag.substring(indexOfSlash + 1);
            imageVersion = "latest";
        } else {
            imageName = imageTag.substring(indexOfSlash + 1, indexOfLastColon);
            imageVersion = imageTag.substring(indexOfLastColon + 1);
        }
        return imageName + "/" + imageVersion;
    }

    public static Boolean isImageVersioned(String imageTag) {
        int indexOfLastColon;
        int indexOfFirstSlash = imageTag.indexOf("/");
        return indexOfFirstSlash < (indexOfLastColon = imageTag.lastIndexOf(":"));
    }

    public static void downloadMarkerLayer(String repo, String imageName, String imageDigests, ArtifactoryManager artifactoryManager) throws IOException {
        String url = "/api/docker/" + repo + "/v2/" + imageName + "/blobs/" + imageDigests;
        artifactoryManager.downloadHeaders(url);
    }

    public static List<String> getArtManifestPath(String imagePath, String repo, CommandType cmd) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(repo + "/" + imagePath);
        paths.add(imagePath);
        int totalSlash = StringUtils.countMatches((String)imagePath, (String)"/");
        if (cmd == CommandType.Push || totalSlash > 3) {
            return paths;
        }
        paths.add(repo + "/library/" + imagePath);
        int secondSlash = org.apache.commons.lang3.StringUtils.ordinalIndexOf((CharSequence)imagePath, (CharSequence)"/", (int)2);
        paths.add(repo + "/library/" + imagePath.substring(secondSlash + 1));
        return paths;
    }

    public static enum CommandType {
        Push,
        Pull;

    }
}

