/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.client;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.access.client.AccessClientException;
import org.jfrog.access.client.model.ErrorsModel;
import org.jfrog.access.client.model.MessageModel;
import org.jfrog.common.JsonParsingException;
import org.jfrog.common.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessClientHttpException
extends AccessClientException {
    private static final Logger log = LoggerFactory.getLogger(AccessClientHttpException.class);
    private static final String GENERIC_ERROR = "Error while trying to connect to service registry (status = %s). Please review router request log for additional information";
    private static final int MIN_ERROR_CODE = 400;
    private final int statusCode;
    private final ErrorsModel errorsModel;

    public AccessClientHttpException(int statusCode, String message) {
        super("HTTP response status " + statusCode + ":" + message);
        this.statusCode = statusCode;
        this.errorsModel = this.accessClientHttpException(message, message);
    }

    public AccessClientHttpException(int statusCode, String message, String body) {
        super("HTTP response status " + statusCode + ":" + message);
        this.statusCode = statusCode;
        this.errorsModel = this.accessClientHttpException(message, body);
    }

    private ErrorsModel accessClientHttpException(String message, String body) {
        ErrorsModel internalErrorModel = null;
        if (StringUtils.isNotBlank((CharSequence)body)) {
            try {
                internalErrorModel = (ErrorsModel)JsonUtils.getInstance().readValue(body, ErrorsModel.class);
            }
            catch (JsonParsingException e) {
                internalErrorModel = this.mapErrorCode(message);
                if (internalErrorModel == null) {
                    log.warn("Unrecognized ErrorsModel by Access. Original message: {}", (Object)message);
                    log.debug("", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.warn("Couldn't parse ErrorsModel from Access. Original message: {}", (Object)message);
                log.debug("", (Throwable)e);
            }
        }
        return internalErrorModel;
    }

    private ErrorsModel mapErrorCode(String message) {
        if (this.statusCode >= 400) {
            ErrorsModel serverErrorsModel = new ErrorsModel();
            serverErrorsModel.setErrors(Collections.singletonList(new MessageModel(Integer.toString(this.statusCode), String.format(GENERIC_ERROR, this.statusCode), message)));
            return serverErrorsModel;
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ErrorsModel getErrorsModel() {
        return this.errorsModel;
    }
}

