/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.interact;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleSegment;
import jetbrains.datalore.base.geometry.DoubleVector;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ%\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007J#\u0010\u001a\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006%"}, d2={"Ljetbrains/datalore/plot/builder/interact/MathUtil;", "", "()V", "addX", "Ljetbrains/datalore/base/geometry/DoubleVector;", "v", "x", "", "addX$plot_builder_portable", "areEqual", "", "p1", "p2", "epsilon", "areEqual$plot_builder_portable", "a", "b", "bottomEdgeOf", "Ljetbrains/datalore/base/geometry/DoubleSegment;", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "distance", "distance$plot_builder_portable", "leftEdgeOf", "liesOnSegment", "c", "polygonContainsCoordinate", "points", "", "coord", "polygonContainsCoordinate$plot_builder_portable", "rightEdgeOf", "subtractX", "subtractX$plot_builder_portable", "topEdgeOf", "ClosestPointChecker", "DoubleRange", "plot-builder-portable"})
public final class MathUtil {
    @NotNull
    public static final MathUtil INSTANCE = new MathUtil();

    private MathUtil() {
    }

    public final boolean polygonContainsCoordinate$plot_builder_portable(@NotNull List<DoubleVector> points, @NotNull DoubleVector coord) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        int intersectionCount = 0;
        int n = 1;
        int n2 = points.size();
        if (n < n2) {
            do {
                double x;
                int i = n++;
                DoubleVector start = points.get(i - 1);
                DoubleVector end = points.get(i);
                if (start.getY() >= coord.getY() && end.getY() >= coord.getY() || start.getY() < coord.getY() && end.getY() < coord.getY() || !((x = start.getX() + (coord.getY() - start.getY()) * (end.getX() - start.getX()) / (end.getY() - start.getY())) <= coord.getX())) continue;
                int n3 = intersectionCount;
                intersectionCount = n3 + 1;
            } while (n < n2);
        }
        return intersectionCount % 2 != 0;
    }

    public final boolean liesOnSegment(@NotNull DoubleVector p1, @NotNull DoubleVector p2, @NotNull DoubleVector c, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new DoubleSegment(p1, p2).distance(c) < epsilon;
    }

    public final boolean areEqual$plot_builder_portable(@NotNull DoubleVector p1, @NotNull DoubleVector p2, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return p1.subtract(p2).length() < epsilon;
    }

    public final boolean areEqual$plot_builder_portable(double a, double b, double epsilon) {
        double d = a - b;
        boolean bl = false;
        return Math.abs(d) < epsilon;
    }

    public final double distance$plot_builder_portable(@NotNull DoubleVector p1, @NotNull DoubleVector p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return new DoubleSegment(p1, p2).length();
    }

    @NotNull
    public final DoubleVector subtractX$plot_builder_portable(@NotNull DoubleVector v, double x) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(v.getX() - x, v.getY());
    }

    @NotNull
    public final DoubleVector addX$plot_builder_portable(@NotNull DoubleVector v, double x) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(v.getX() + x, v.getY());
    }

    @NotNull
    public final DoubleSegment leftEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getLeft(), rect2.getTop()), new DoubleVector(rect2.getLeft(), rect2.getBottom()));
    }

    @NotNull
    public final DoubleSegment topEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getLeft(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getTop()));
    }

    @NotNull
    public final DoubleSegment rightEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getRight(), rect2.getTop()), new DoubleVector(rect2.getRight(), rect2.getBottom()));
    }

    @NotNull
    public final DoubleSegment bottomEdgeOf(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        return new DoubleSegment(new DoubleVector(rect2.getLeft(), rect2.getBottom()), new DoubleVector(rect2.getRight(), rect2.getBottom()));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0003H\u0002R\"\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/builder/interact/MathUtil$ClosestPointChecker;", "", "x", "", "y", "(DD)V", "target", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljetbrains/datalore/base/geometry/DoubleVector;)V", "<set-?>", "coord", "getCoord", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "distance", "getDistance", "()D", "getTarget", "check", "", "compare", "Ljetbrains/datalore/plot/builder/interact/MathUtil$ClosestPointChecker$COMPARISON_RESULT;", "setNewClosestCoord", "", "COMPARISON_RESULT", "plot-builder-portable"})
    public static final class ClosestPointChecker {
        @NotNull
        private final DoubleVector target;
        private double distance;
        @Nullable
        private DoubleVector coord;

        public ClosestPointChecker(@NotNull DoubleVector target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
            this.distance = -1.0;
        }

        @NotNull
        public final DoubleVector getTarget() {
            return this.target;
        }

        public final double getDistance() {
            return this.distance;
        }

        @Nullable
        public final DoubleVector getCoord() {
            return this.coord;
        }

        public ClosestPointChecker(double x, double y) {
            this(new DoubleVector(x, y));
        }

        public final boolean check(@NotNull DoubleVector coord) {
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            COMPARISON_RESULT cmpResult = this.compare(coord);
            return cmpResult == COMPARISON_RESULT.NEW_CLOSER || cmpResult == COMPARISON_RESULT.EQUAL;
        }

        @NotNull
        public final COMPARISON_RESULT compare(@NotNull DoubleVector coord) {
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            double newDistance = INSTANCE.distance$plot_builder_portable(this.target, coord);
            if (this.distance < 0.0) {
                this.setNewClosestCoord(coord, newDistance);
                return COMPARISON_RESULT.NEW_CLOSER;
            }
            if (this.distance < newDistance) {
                return COMPARISON_RESULT.NEW_FARTHER;
            }
            if (this.distance == newDistance) {
                return COMPARISON_RESULT.EQUAL;
            }
            this.setNewClosestCoord(coord, newDistance);
            return COMPARISON_RESULT.NEW_CLOSER;
        }

        private final void setNewClosestCoord(DoubleVector coord, double distance) {
            this.distance = distance;
            this.coord = coord;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/builder/interact/MathUtil$ClosestPointChecker$COMPARISON_RESULT;", "", "(Ljava/lang/String;I)V", "NEW_CLOSER", "NEW_FARTHER", "EQUAL", "plot-builder-portable"})
        public static final class COMPARISON_RESULT
        extends Enum<COMPARISON_RESULT> {
            public static final /* enum */ COMPARISON_RESULT NEW_CLOSER = new COMPARISON_RESULT();
            public static final /* enum */ COMPARISON_RESULT NEW_FARTHER = new COMPARISON_RESULT();
            public static final /* enum */ COMPARISON_RESULT EQUAL = new COMPARISON_RESULT();
            private static final /* synthetic */ COMPARISON_RESULT[] $VALUES;

            public static COMPARISON_RESULT[] values() {
                return (COMPARISON_RESULT[])$VALUES.clone();
            }

            public static COMPARISON_RESULT valueOf(String value) {
                return Enum.valueOf(COMPARISON_RESULT.class, value);
            }

            static {
                $VALUES = cOMPARISON_RESULTArray = new COMPARISON_RESULT[]{COMPARISON_RESULT.NEW_CLOSER, COMPARISON_RESULT.NEW_FARTHER, COMPARISON_RESULT.EQUAL};
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "", "myStart", "", "myLength", "(DD)V", "contains", "", "value", "end", "inside", "v", "length", "move", "delta", "moveLeft", "moveRight", "overlaps", "start", "Companion", "plot-builder-portable"})
    public static final class DoubleRange {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double myStart;
        private final double myLength;

        private DoubleRange(double myStart, double myLength) {
            this.myStart = myStart;
            this.myLength = myLength;
            if (this.myLength < 0.0) {
                throw new IllegalStateException("Length should be positive");
            }
        }

        public final double length() {
            return this.myLength;
        }

        public final boolean overlaps(@NotNull DoubleRange v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return this.start() <= v.end() && v.start() <= this.end();
        }

        public final boolean inside(@NotNull DoubleRange v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return this.start() >= v.start() && this.end() <= v.end();
        }

        public final boolean contains(double value) {
            return value >= this.start() && value <= this.end();
        }

        public final double start() {
            return this.myStart;
        }

        public final double end() {
            return this.myStart + this.length();
        }

        @NotNull
        public final DoubleRange move(double delta) {
            return Companion.withStartAndLength(this.start() + delta, this.length());
        }

        @NotNull
        public final DoubleRange moveLeft(double delta) {
            if (delta < 0.0) {
                throw new IllegalStateException("Value should be positive");
            }
            return Companion.withStartAndLength(this.start() - delta, this.length());
        }

        @NotNull
        public final DoubleRange moveRight(double delta) {
            if (delta < 0.0) {
                throw new IllegalStateException("Value should be positive");
            }
            return Companion.withStartAndLength(this.start() + delta, this.length());
        }

        public /* synthetic */ DoubleRange(double myStart, double myLength, DefaultConstructorMarker $constructor_marker) {
            this(myStart, myLength);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange$Companion;", "", "()V", "withStartAndEnd", "Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "start", "", "end", "withStartAndLength", "length", "plot-builder-portable"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DoubleRange withStartAndEnd(double start, double end) {
                boolean bl = false;
                double rangeStart = Math.min(start, end);
                boolean bl2 = false;
                double rangeLength = Math.max(start, end) - rangeStart;
                return new DoubleRange(rangeStart, rangeLength, null);
            }

            @NotNull
            public final DoubleRange withStartAndLength(double start, double length) {
                return new DoubleRange(start, length, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

