/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale;

import java.util.Collection;
import java.util.List;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.scale.ContinuousScale;
import jetbrains.datalore.plot.base.scale.DiscreteScale;
import jetbrains.datalore.plot.base.scale.Mappers;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\t2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012J@\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0016\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\tJC\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00142\u0006\u0010\u0016\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/base/scale/Scales;", "", "()V", "continuousDomain", "Ljetbrains/datalore/plot/base/Scale;", "T", "name", "", "mapper", "Lkotlin/Function1;", "", "continuousRange", "", "aes", "Ljetbrains/datalore/plot/base/Aes;", "continuousDomainNumericRange", "discreteDomain", "domainValues", "", "pureDiscrete", "", "outputValues", "defaultOutputValue", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/Object;)Ljetbrains/datalore/plot/base/Scale;", "plot-base-portable"})
public final class Scales {
    @NotNull
    public static final Scales INSTANCE = new Scales();

    private Scales() {
    }

    @NotNull
    public final <T> Scale<T> continuousDomain(@NotNull String name, @NotNull Aes<T> aes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return new ContinuousScale(name, Mappers.INSTANCE.undefined(), aes.isNumeric());
    }

    @NotNull
    public final Scale<Double> continuousDomainNumericRange(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ContinuousScale(name, Mappers.INSTANCE.undefined(), true);
    }

    @NotNull
    public final <T> Scale<T> continuousDomain(@NotNull String name, @NotNull Function1<? super Double, ? extends T> mapper, boolean continuousRange) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new ContinuousScale<T>(name, mapper, continuousRange);
    }

    @NotNull
    public final <T> Scale<T> discreteDomain(@NotNull String name, @NotNull Collection<? extends Object> domainValues) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        return this.discreteDomain(name, domainValues, Mappers.INSTANCE.undefined());
    }

    @NotNull
    public final <T> Scale<T> discreteDomain(@NotNull String name, @NotNull Collection<? extends Object> domainValues, @NotNull Function1<? super Double, ? extends T> mapper) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new DiscreteScale<T>(name, domainValues, mapper);
    }

    @NotNull
    public final <T> Scale<T> pureDiscrete(@NotNull String name, @NotNull List<? extends Object> domainValues, @NotNull List<? extends T> outputValues, T defaultOutputValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        return this.discreteDomain(name, (Collection<? extends Object>)domainValues).with().mapper(Mappers.INSTANCE.discrete(outputValues, defaultOutputValue)).build();
    }
}

