/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svgMapper.awt;

import java.awt.image.BufferedImage;
import java.io.IOException;
import jetbrains.datalore.base.awt.BufferedImageExtKt;
import jetbrains.datalore.vis.svg.SvgImageElementEx;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/vis/svgMapper/awt/RGBEncoderAwt;", "Ljetbrains/datalore/vis/svg/SvgImageElementEx$RGBEncoder;", "()V", "toDataUrl", "", "width", "", "height", "argbValues", "", "vis-svg-mapper"})
public final class RGBEncoderAwt
implements SvgImageElementEx.RGBEncoder {
    @Override
    @NotNull
    public String toDataUrl(int width2, int height, @NotNull int[] argbValues) {
        Intrinsics.checkNotNullParameter((Object)argbValues, (String)"argbValues");
        BufferedImage bufferedImage = new BufferedImage(width2, height, 2);
        int n = 0;
        if (n < height) {
            do {
                int y2 = n++;
                int n2 = 0;
                if (n2 >= width2) continue;
                do {
                    int x2 = n2++;
                    bufferedImage.setRGB(x2, y2, argbValues[y2 * width2 + x2]);
                } while (n2 < width2);
            } while (n < height);
        }
        try {
            return BufferedImageExtKt.toPngDataUri(bufferedImage);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't build image " + width2 + " X " + height, e);
        }
    }
}

