/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jetbrains.datalore.base.stringFormat.StringFormat;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.assemble.facet.FacetGrid;
import jetbrains.datalore.plot.builder.assemble.facet.FacetWrap;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u001e\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/config/FacetConfig;", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "options", "", "", "", "(Ljava/util/Map;)V", "createFacets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "dataByLayer", "", "Ljetbrains/datalore/plot/base/DataFrame;", "createGrid", "createWrap", "getDirOption", "Ljetbrains/datalore/plot/builder/assemble/facet/FacetWrap$Direction;", "getFormatterOption", "Lkotlin/Function1;", "optionName", "getOrderOption", "", "toFormatterVal", "optionVal", "toOrderVal", "plot-config-portable"})
public final class FacetConfig
extends OptionsAccessor {
    public FacetConfig(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        super(options, null, 2, null);
    }

    @NotNull
    public final PlotFacets createFacets(@NotNull List<DataFrame> dataByLayer) {
        PlotFacets plotFacets;
        Intrinsics.checkNotNullParameter(dataByLayer, (String)"dataByLayer");
        String name = this.getStringSafe("name");
        if (Intrinsics.areEqual((Object)name, (Object)"grid")) {
            plotFacets = this.createGrid(dataByLayer);
        } else if (Intrinsics.areEqual((Object)name, (Object)"wrap")) {
            plotFacets = this.createWrap(dataByLayer);
        } else {
            throw new IllegalArgumentException("Facet 'grid' or 'wrap' expected but was: `" + name + '`');
        }
        return plotFacets;
    }

    private final PlotFacets createGrid(List<DataFrame> dataByLayer) {
        String nameX = null;
        LinkedHashSet<Object> levelsX = new LinkedHashSet<Object>();
        if (this.has("x")) {
            nameX = this.getStringSafe("x");
            for (DataFrame data : dataByLayer) {
                if (!DataFrameUtil.INSTANCE.hasVariable(data, nameX)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, nameX);
                levelsX.addAll(data.distinctValues(variable));
            }
        }
        String nameY = null;
        LinkedHashSet<Object> levelsY = new LinkedHashSet<Object>();
        if (this.has("y")) {
            nameY = this.getStringSafe("y");
            for (DataFrame data : dataByLayer) {
                if (!DataFrameUtil.INSTANCE.hasVariable(data, nameY)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, nameY);
                levelsY.addAll(data.distinctValues(variable));
            }
        }
        return new FacetGrid(nameX, nameY, new ArrayList(levelsX), new ArrayList(levelsY), this.getOrderOption("x_order"), this.getOrderOption("y_order"), this.getFormatterOption("x_format"), this.getFormatterOption("y_format"));
    }

    /*
     * WARNING - void declaration
     */
    private final PlotFacets createWrap(List<DataFrame> dataByLayer) {
        void $this$mapTo$iv$iv;
        Function1<Object, String> function1;
        int n;
        List<Function1<Object, String>> list2;
        int n2;
        Collection collection;
        void $this$mapTo$iv$iv22;
        List<String> facets = this.getAsStringList("facets");
        Integer ncol = this.getInteger("ncol");
        Integer nrow = this.getInteger("nrow");
        ArrayList<List> facetLevels = new ArrayList<List>();
        for (String name : facets) {
            HashSet levels = new HashSet();
            for (DataFrame data : dataByLayer) {
                if (!DataFrameUtil.INSTANCE.hasVariable(data, name)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, name);
                levels.addAll(CollectionsKt.filterNotNull((Iterable)data.get(variable)));
            }
            facetLevels.add(CollectionsKt.toList((Iterable)levels));
        }
        Iterable $this$map$iv = this.getAsList("order");
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator iterator2 = $this$mapTo$iv$iv22.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv22;
            n2 = 0;
            list2 = this.toOrderVal(it);
            collection.add(list2);
        }
        List orderOption = (List)destination$iv$iv22;
        $i$f$map = facets.size();
        collection = orderOption;
        boolean $this$mapTo$iv$iv22 = false;
        boolean destination$iv$iv22 = false;
        Iterable<Object> $i$f$mapTo22 = new ArrayList<Function1<Object, String>>($i$f$map);
        boolean bl = false;
        int item$iv$iv = 0;
        item$iv$iv = 0;
        int n3 = $i$f$map;
        while (item$iv$iv < n3) {
            n2 = item$iv$iv++;
            boolean bl2 = false;
            n = n2;
            list2 = $i$f$mapTo22;
            boolean bl3 = false;
            function1 = Integer.valueOf(0);
            ((ArrayList)list2).add(function1);
        }
        list2 = $i$f$mapTo22;
        List ordering = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)list2), (int)facets.size());
        Iterable $this$map$iv2 = this.getAsList("format");
        boolean $i$f$map2 = false;
        $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            void it;
            Object item$iv$iv2;
            Object t = item$iv$iv2 = iterator3.next();
            collection = destination$iv$iv;
            boolean bl4 = false;
            list2 = this.toFormatterVal(it);
            collection.add(list2);
        }
        List formatterOption = (List)destination$iv$iv;
        int n4 = facets.size();
        collection = formatterOption;
        boolean bl5 = false;
        boolean bl6 = false;
        ArrayList arrayList = new ArrayList(n4);
        boolean bl7 = false;
        int n5 = 0;
        n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n = n5++;
            boolean bl8 = false;
            int n7 = n;
            list2 = arrayList;
            boolean bl9 = false;
            function1 = PlotFacets.Companion.getDEF_FORMATTER();
            ((ArrayList)list2).add(function1);
        }
        list2 = arrayList;
        List formatters = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)list2), (int)facets.size());
        return new FacetWrap(facets, (List<? extends List<? extends Object>>)facetLevels, nrow, ncol, this.getDirOption(), ordering, formatters);
    }

    private final int getOrderOption(String optionName) {
        return this.toOrderVal(this.get(optionName));
    }

    private final int toOrderVal(Object optionVal) {
        int n;
        Object object = optionVal;
        if (object == null) {
            n = 0;
        } else if (object instanceof Number) {
            n = ((Number)optionVal).intValue();
        } else {
            throw new IllegalArgumentException("Unsupported `order` value: " + optionVal + ".\nUse: 1 (natural), -1 (descending) or 0 (no ordering).");
        }
        return n;
    }

    private final FacetWrap.Direction getDirOption() {
        FacetWrap.Direction direction;
        Object opt = this.get("dir");
        if (opt == null) {
            direction = FacetWrap.Direction.H;
        } else {
            String string = opt.toString();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
            String string4 = string3;
            if (Intrinsics.areEqual((Object)string4, (Object)"V")) {
                direction = FacetWrap.Direction.V;
            } else if (Intrinsics.areEqual((Object)string4, (Object)"H")) {
                direction = FacetWrap.Direction.H;
            } else {
                throw new IllegalArgumentException("Unsupported `dir` value: " + opt + ".\nUse: 'H' (horizontal) or 'V' (vertical).");
            }
        }
        return direction;
    }

    private final Function1<Object, String> toFormatterVal(Object optionVal) {
        Object object = optionVal;
        if (object != null) {
            StringFormat fmt = StringFormat.Companion.forOneArg$default(StringFormat.Companion, optionVal.toString(), null, null, 6, null);
            return (Function1)new Function1<Object, String>(fmt){
                final /* synthetic */ StringFormat $fmt;
                {
                    this.$fmt = $fmt;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull Object value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    return this.$fmt.format(value);
                }
            };
        }
        return PlotFacets.Companion.getDEF_FORMATTER();
    }

    private final Function1<Object, String> getFormatterOption(String optionName) {
        return this.toFormatterVal(this.get(optionName));
    }
}

